package com.xebialabs.xlplatform.extensions.exportcis

import java.io.File
import java.nio.file.Path

import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, Step, StepExitCode}
import com.xebialabs.deployit.repository.RepositoryServiceHolder._
import com.xebialabs.deployit.repository.WorkDirContext
import com.xebialabs.xlplatform.endpoints.{AuthenticatedData, ServicesSupport}
import com.xebialabs.xlplatform.sugar.PathSugar._
import com.xebialabs.xlplatform.extensions.exportcis.archive.RepositoryImporter
import grizzled.slf4j.Logging

import scala.jdk.CollectionConverters._
import scala.util.{Failure, Success}

trait CisImportSupport extends ServicesSupport with Logging {

  def `import`(archive: Path)(implicit auth: AuthenticatedData): String = {
    WorkDirContext.initWorkdir("import")
    taskCreationService.createWithStepBlock(
      auth.toAuthentication,
      s"Import configuration items from '$archive'",
      List[Step](ImportStep(archive)).asJava,
      Map("from" -> archive.path).asJava
    )
  }
}

case class ImportStep(archive: File) extends Step with Logging {

  override def execute(ctx: ExecutionContext): StepExitCode =
    new RepositoryImporter(getRepositoryService, ctx).`import`(archive) match {
      case Success(_) => StepExitCode.SUCCESS
      case Failure(e) =>
        logger.error(s"Failed to import $archive", e)
        StepExitCode.FAIL
    }

  override def getDescription: String = s"Import configuration items from '$archive'"
  override def getOrder: Int = Step.DEFAULT_ORDER
}
