import time
from com.xebialabs.deployit.engine.api.execution import TaskExecutionState
from asserts import *

def assert_step_state(taskId, stepId, expectedState):
    step = task2.step(taskId, stepId)
    assert_not_none(step)
    assert_equals(expectedState, step.state)


def assert_task_state(taskId, expectedState):
    task = task2.get(taskId)
    assert_not_none(task)
    assert_equals(expectedState, task.state)


def wait_for_task_state(task_id, expected_state, wait_seconds = 20):
    retries = 1
    task = task2.get(task_id)

    while task.state != expected_state:
        retries = retries + 1
        if retries > wait_seconds:
            raise AssertionError(
                    "Error waiting for task state of task: " + task_id + ". Expected state: " + expected_state.name() + " current: " + task.state.name())
        time.sleep(1)
        task = task2.get(task_id)


def wait_for_step_state(task_id, step_id, expected_state, wait_seconds = 20):
    retries = 1
    step = task2.step(task_id, step_id)
    while step.state != expected_state:
        retries = retries + 1
        if retries > wait_seconds:
            raise AssertionError(
                    "Error waiting for step state of task: " + task_id + ", step id: " + step_id + ". Expected state: " + expected_state.name() + " current: " + step.state.name())
        time.sleep(1)
        step = task2.step(task_id, step_id)


def schedule_and_wait(task_id, date):
    task2.schedule(task_id, date)
    wait_for_task_state(task_id, TaskExecutionState.SCHEDULED)


def abort_and_wait(task_id):
    task2.abort(task_id)
    wait_for_task_state(task_id, TaskExecutionState.ABORTED)


def stop_and_wait(task_id):
    task2.stop(task_id)
    wait_for_task_state(task_id, TaskExecutionState.STOPPED)
