/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.oidc.authentication;

import com.xebialabs.platform.sso.oidc.authentication.DefaultOidcIdTokenValidatorFactory;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class CustomOidcIdTokenDecoderFactory
implements JwtDecoderFactory<ClientRegistration> {
    private static final String MISSING_SIGNATURE_VERIFIER_ERROR_CODE = "missing_signature_verifier";
    private static final Map<JwsAlgorithm, String> jcaAlgorithmMappings = new HashMap<JwsAlgorithm, String>();
    private static final Converter<Map<String, Object>, Map<String, Object>> DEFAULT_CLAIM_TYPE_CONVERTER = new ClaimTypeConverter(CustomOidcIdTokenDecoderFactory.createDefaultClaimTypeConverters());
    private final Map<String, JwtDecoder> jwtDecoders = new ConcurrentHashMap<String, JwtDecoder>();
    private Function<ClientRegistration, OAuth2TokenValidator<Jwt>> jwtValidatorFactory = new DefaultOidcIdTokenValidatorFactory();
    private Function<ClientRegistration, JwsAlgorithm> jwsAlgorithmResolver = clientRegistration -> SignatureAlgorithm.RS256;
    private Function<ClientRegistration, Converter<Map<String, Object>, Map<String, Object>>> claimTypeConverterFactory = clientRegistration -> DEFAULT_CLAIM_TYPE_CONVERTER;
    private RestOperations restOperations = new RestTemplate();

    public static Map<String, Converter<Object, ?>> createDefaultClaimTypeConverters() {
        Converter<Object, ?> booleanConverter = CustomOidcIdTokenDecoderFactory.getConverter(TypeDescriptor.valueOf(Boolean.class));
        Converter<Object, ?> instantConverter = CustomOidcIdTokenDecoderFactory.getConverter(TypeDescriptor.valueOf(Instant.class));
        Converter<Object, ?> urlConverter = CustomOidcIdTokenDecoderFactory.getConverter(TypeDescriptor.valueOf(URL.class));
        Converter<Object, ?> stringConverter = CustomOidcIdTokenDecoderFactory.getConverter(TypeDescriptor.valueOf(String.class));
        Converter<Object, ?> collectionStringConverter = CustomOidcIdTokenDecoderFactory.getConverter(TypeDescriptor.collection(Collection.class, (TypeDescriptor)TypeDescriptor.valueOf(String.class)));
        HashMap claimTypeConverters = new HashMap();
        claimTypeConverters.put("iss", urlConverter);
        claimTypeConverters.put("aud", collectionStringConverter);
        claimTypeConverters.put("nonce", stringConverter);
        claimTypeConverters.put("exp", instantConverter);
        claimTypeConverters.put("iat", instantConverter);
        claimTypeConverters.put("auth_time", instantConverter);
        claimTypeConverters.put("amr", collectionStringConverter);
        claimTypeConverters.put("email_verified", booleanConverter);
        claimTypeConverters.put("phone_number_verified", booleanConverter);
        claimTypeConverters.put("updated_at", instantConverter);
        return claimTypeConverters;
    }

    private static Converter<Object, ?> getConverter(TypeDescriptor targetDescriptor) {
        TypeDescriptor sourceDescriptor = TypeDescriptor.valueOf(Object.class);
        return source -> ClaimConversionService.getSharedInstance().convert(source, sourceDescriptor, targetDescriptor);
    }

    public JwtDecoder createDecoder(ClientRegistration clientRegistration) {
        Assert.notNull((Object)clientRegistration, (String)"clientRegistration cannot be null");
        return this.jwtDecoders.computeIfAbsent(clientRegistration.getRegistrationId(), key -> {
            NimbusJwtDecoder jwtDecoder = this.buildDecoder(clientRegistration);
            jwtDecoder.setJwtValidator(this.jwtValidatorFactory.apply(clientRegistration));
            Converter<Map<String, Object>, Map<String, Object>> claimTypeConverter = this.claimTypeConverterFactory.apply(clientRegistration);
            if (claimTypeConverter != null) {
                jwtDecoder.setClaimSetConverter(claimTypeConverter);
            }
            return jwtDecoder;
        });
    }

    private NimbusJwtDecoder buildDecoder(ClientRegistration clientRegistration) {
        JwsAlgorithm jwsAlgorithm = this.jwsAlgorithmResolver.apply(clientRegistration);
        if (jwsAlgorithm != null && SignatureAlgorithm.class.isAssignableFrom(jwsAlgorithm.getClass())) {
            String jwkSetUri = clientRegistration.getProviderDetails().getJwkSetUri();
            if (!StringUtils.hasText((String)jwkSetUri)) {
                OAuth2Error oauth2Error = new OAuth2Error(MISSING_SIGNATURE_VERIFIER_ERROR_CODE, "Failed to find a Signature Verifier for Client Registration: '" + clientRegistration.getRegistrationId() + "'. Check to ensure you have configured the JwkSet URI.", null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            return NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm((SignatureAlgorithm)jwsAlgorithm).restOperations(this.restOperations).build();
        }
        if (jwsAlgorithm != null && MacAlgorithm.class.isAssignableFrom(jwsAlgorithm.getClass())) {
            String clientSecret = clientRegistration.getClientSecret();
            if (!StringUtils.hasText((String)clientSecret)) {
                OAuth2Error oauth2Error = new OAuth2Error(MISSING_SIGNATURE_VERIFIER_ERROR_CODE, "Failed to find a Signature Verifier for Client Registration: '" + clientRegistration.getRegistrationId() + "'. Check to ensure you have configured the client secret.", null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(clientSecret.getBytes(StandardCharsets.UTF_8), jcaAlgorithmMappings.get(jwsAlgorithm));
            return NimbusJwtDecoder.withSecretKey((SecretKey)secretKeySpec).macAlgorithm((MacAlgorithm)jwsAlgorithm).build();
        }
        OAuth2Error oauth2Error = new OAuth2Error(MISSING_SIGNATURE_VERIFIER_ERROR_CODE, "Failed to find a Signature Verifier for Client Registration: '" + clientRegistration.getRegistrationId() + "'. Check to ensure you have configured a valid JWS Algorithm: '" + jwsAlgorithm + "'", null);
        throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
    }

    public void setJwtValidatorFactory(Function<ClientRegistration, OAuth2TokenValidator<Jwt>> jwtValidatorFactory) {
        Assert.notNull(jwtValidatorFactory, (String)"jwtValidatorFactory cannot be null");
        this.jwtValidatorFactory = jwtValidatorFactory;
    }

    public void setJwsAlgorithmResolver(Function<ClientRegistration, JwsAlgorithm> jwsAlgorithmResolver) {
        Assert.notNull(jwsAlgorithmResolver, (String)"jwsAlgorithmResolver cannot be null");
        this.jwsAlgorithmResolver = jwsAlgorithmResolver;
    }

    public void setClaimTypeConverterFactory(Function<ClientRegistration, Converter<Map<String, Object>, Map<String, Object>>> claimTypeConverterFactory) {
        Assert.notNull(claimTypeConverterFactory, (String)"claimTypeConverterFactory cannot be null");
        this.claimTypeConverterFactory = claimTypeConverterFactory;
    }

    public void setRestOperations(RestOperations restOperations) {
        Assert.notNull((Object)restOperations, (String)"restOperations cannot be null");
        this.restOperations = restOperations;
    }

    static {
        jcaAlgorithmMappings.put((JwsAlgorithm)MacAlgorithm.HS256, "HmacSHA256");
        jcaAlgorithmMappings.put((JwsAlgorithm)MacAlgorithm.HS384, "HmacSHA384");
        jcaAlgorithmMappings.put((JwsAlgorithm)MacAlgorithm.HS512, "HmacSHA512");
    }
}

