package com.xebialabs.platform.sso.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;

public class RS256SignatureVerifier implements SignatureVerifier {
    public final static String SIGNING_ALGORITHM = "SHA256withRSA";
    private final PublicKey publicKey;

    public RS256SignatureVerifier(final PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public void verify(byte[] content, byte[] signature) {
        try {
            Signature verifier = Signature.getInstance(SIGNING_ALGORITHM);
            verifier.initVerify(publicKey);
            verifier.update(content);
            if (!verifier.verify(signature)) {
                throw new InvalidSignatureException("JWT Token failed RS256 signature verification");
            }
        } catch (NoSuchAlgorithmException | SignatureException | InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * @return the JCA/JCE algorithm name.
     */
    @Override
    public String algorithm() {
        return "RS256";
    }
}
