package com.xebialabs.platform.sso.oidc.policy;

import java.util.List;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;

/**
 * Policy to convert OIDC claims to GrantedAuthorities.
 * <p>
 * See: http://openid.net/specs/openid-connect-core-1_0.html#StandardClaims
 */
public interface ClaimsToGrantedAuthoritiesPolicy {

    /**
     * Derive the {@link GrantedAuthority}s from the claims provided by the IDP.
     * <p>
     * It seems there's no real standard claim for groups/roles. In Okta it seems to
     * be named 'groups' in KeyCloak it can be configured and filled with Groups or Roles.
     *
     * @param oidcClaims a map with the claims (Values can be strings, integers, ..)
     * @return the list with {@link GrantedAuthority}s
     */
    List<GrantedAuthority> claimsToGrantedAuthorities(Map<String, Object> oidcClaims);
}
