package com.xebialabs.platform.sso.oidc.policy.impl;

import com.xebialabs.platform.sso.oidc.exceptions.InsufficientClaimsException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToUserNamePolicy;
import org.springframework.util.Assert;

import java.util.Map;

/**
 * Provides default behaviour for case when username is mandatory.
 */
public class DefaultClaimsToUserPolicy implements ClaimsToUserNamePolicy {
    private final String userNameClaimName;

    public DefaultClaimsToUserPolicy(String userNameClaimName) {
        Assert.hasText(userNameClaimName, "userNameClaimName must contain a property name");
        this.userNameClaimName = userNameClaimName;
    }

    @Override
    public String claimsToUserName(Map<String, Object> oidcClaims) {
        Object pu = oidcClaims.get(userNameClaimName);
        if (pu == null) {
            throw new InsufficientClaimsException("Could not determine username: OIDC claims do not contain a property '" + userNameClaimName + "'");
        }
        if (!(pu instanceof String)) {
            throw new InsufficientClaimsException("Could not determine username: OIDC claims do not contain a string property '" + userNameClaimName + "'");
        }
        String userName = ((String) pu).toLowerCase();
        if (userName.isEmpty()) {
            throw new InsufficientClaimsException("Could not determine username: OIDC claims contain an empty '" + userNameClaimName + "'");
        }
        return userName;
    }
}
