/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.oidc.web;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;

public class CustomAuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    private final OAuth2AuthorizationRequestResolver defaultResolver;
    private final Map<String, Object> userDefinedAdditionalParameters;
    private final StringKeyGenerator secureKeyGenerator = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 96);

    public CustomAuthorizationRequestResolver(ClientRegistrationRepository repo, String authorizationRequestBaseUri, Map<String, Object> additionalParameters) {
        this.defaultResolver = new DefaultOAuth2AuthorizationRequestResolver(repo, authorizationRequestBaseUri);
        this.userDefinedAdditionalParameters = additionalParameters;
    }

    public CustomAuthorizationRequestResolver(ClientRegistrationRepository repo, String authorizationRequestBaseUri) {
        this.defaultResolver = new DefaultOAuth2AuthorizationRequestResolver(repo, authorizationRequestBaseUri);
        this.userDefinedAdditionalParameters = new HashMap<String, Object>();
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest servletRequest) {
        OAuth2AuthorizationRequest req = this.defaultResolver.resolve(servletRequest);
        return this.customizeAuthorizationRequest(req);
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest servletRequest, String clientRegistrationId) {
        OAuth2AuthorizationRequest req = this.defaultResolver.resolve(servletRequest, clientRegistrationId);
        return this.customizeAuthorizationRequest(req);
    }

    private OAuth2AuthorizationRequest customizeAuthorizationRequest(OAuth2AuthorizationRequest req) {
        if (null == req) {
            return null;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(req.getAttributes());
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>(req.getAdditionalParameters());
        this.addPkceParameters(attributes, additionalParameters);
        this.addAdditionalParameters(additionalParameters);
        return OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)req).attributes(attributes).additionalParameters(additionalParameters).build();
    }

    private void addAdditionalParameters(Map<String, Object> additionalParameters) {
        if (null != this.userDefinedAdditionalParameters) {
            additionalParameters.putAll(this.userDefinedAdditionalParameters);
        }
    }

    private void addPkceParameters(Map<String, Object> attributes, Map<String, Object> additionalParameters) {
        String codeVerifier = this.secureKeyGenerator.generateKey();
        attributes.put("code_verifier", codeVerifier);
        try {
            String codeChallenge = CustomAuthorizationRequestResolver.createHash(codeVerifier);
            additionalParameters.put("code_challenge", codeChallenge);
            additionalParameters.put("code_challenge_method", "S256");
        }
        catch (NoSuchAlgorithmException e) {
            additionalParameters.put("code_challenge", codeVerifier);
        }
    }

    private static String createHash(String value) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(value.getBytes(StandardCharsets.US_ASCII));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }
}

