/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.oidc.policy.impl;

import com.xebialabs.platform.sso.oidc.exceptions.InvalidRoleClaimsListException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.Assert;

public class DefaultClaimsToGrantedAuthoritiesPolicy
implements ClaimsToGrantedAuthoritiesPolicy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultClaimsToGrantedAuthoritiesPolicy.class);
    private static final Pattern CLAIM_COMPONENT = Pattern.compile("^((\\\\.|[^\\\\.])+?)\\.");
    private static final Pattern BACKSLASH_CHARACTER = Pattern.compile("\\\\(.)");
    private final String rolesClaimName;

    public DefaultClaimsToGrantedAuthoritiesPolicy(String rolesClaimName) {
        Assert.hasText((String)rolesClaimName, (String)"rolesClaimName must contain a property name");
        this.rolesClaimName = rolesClaimName;
    }

    @Override
    public List<GrantedAuthority> claimsToGrantedAuthorities(Map<String, Object> oidcClaims) {
        List<String> claimPath = this.splitClaimPath(this.rolesClaimName);
        logger.debug("Got claim path: {} for rolesClaimName: {}", claimPath, (Object)this.rolesClaimName);
        try {
            List<String> extractedRoles = this.getRolesFromOidcClaims(oidcClaims, claimPath);
            logger.debug("Extracted groups/roles: {}", extractedRoles);
            return extractedRoles.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        }
        catch (ClassCastException e) {
            throw new InvalidRoleClaimsListException(String.format("Role claims name in property [%s] contained non string values", this.rolesClaimName));
        }
    }

    private List<String> splitClaimPath(String claimName) {
        LinkedList<String> claimComponents = new LinkedList<String>();
        Matcher m = CLAIM_COMPONENT.matcher(claimName);
        int start = 0;
        while (m.find()) {
            claimComponents.add(BACKSLASH_CHARACTER.matcher(m.group(1)).replaceAll("$1"));
            start = m.end();
            m.region(start, claimName.length());
        }
        if (claimName.length() > start) {
            claimComponents.add(BACKSLASH_CHARACTER.matcher(claimName.substring(start)).replaceAll("$1"));
        }
        return claimComponents;
    }

    private List<String> getRolesFromOidcClaims(Map<String, Object> oidcClaims, List<String> claimPath) {
        ArrayList<String> roles = new ArrayList<String>();
        int length = claimPath.size();
        int i = 0;
        Map jsonObject = oidcClaims;
        for (String path : claimPath) {
            if (++i == length) {
                ArrayList last = jsonObject.getOrDefault(path, new ArrayList());
                if (last instanceof String) {
                    roles.add((String)((Object)last));
                    continue;
                }
                if (!(last instanceof List)) {
                    throw new InvalidRoleClaimsListException(String.format("Role claims in property [%s] are not a list", this.rolesClaimName));
                }
                roles.addAll(last);
                continue;
            }
            Map nested = (Map)jsonObject.get(path);
            if (nested == null) break;
            jsonObject = nested;
        }
        return roles;
    }
}

