package com.xebialabs.platform.sso.oidc.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import com.xebialabs.deployit.util.MustacheRenderer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class DefaultLogoutSuccessHandler implements LogoutSuccessHandler {
    private final MustacheRenderer mustacheRenderer;

    public DefaultLogoutSuccessHandler(Map<String, String> settings) {
        this(new ClassPathResource("com/xebialabs/platform/sso/oidc/web/modal-layout.mustache"), new ClassPathResource("com/xebialabs/platform/sso/oidc/web/logout-success.mustache"), settings);
    }

    public DefaultLogoutSuccessHandler(Resource layout, Resource content, Map<String, String> settings) {
        Map<String, Resource> partials = new HashMap<>();
        partials.put("content", content);   // name of the partial in the modal-layoutTemplate

        Map<String, String> context = new HashMap<>(settings);
        this.mustacheRenderer = new MustacheRenderer(layout, partials, context);
    }

    @Override
    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        mustacheRenderer.render(response);
    }
}
