package com.xebialabs.platform.sso.oidc.policy.impl;

import java.util.Collection;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;

import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;

/**
 * Extract GrantedAuthorities from JWT Token for OAuth2 Token Based Authentication
 */
public class GrantedAuthoritiesExtractor implements Converter<Jwt, Collection<GrantedAuthority>> {

    private final ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy;

    public GrantedAuthoritiesExtractor(final ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        this.claimsToGrantedAuthoritiesPolicy = claimsToGrantedAuthoritiesPolicy;
    }

    public Collection<GrantedAuthority> convert(Jwt jwt) {
        return claimsToGrantedAuthoritiesPolicy.claimsToGrantedAuthorities(jwt.getClaims());
    }
}
