package com.xebialabs.platform.sso.oidc.service;

import java.util.List;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.util.StringUtils;

import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.user.CustomOidcUser;

public class XLOidcUserService extends OidcUserService {

    private final ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy;

    public XLOidcUserService(final ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        this.claimsToGrantedAuthoritiesPolicy = claimsToGrantedAuthoritiesPolicy;
    }

    @Override
    public OidcUser loadUser(final OidcUserRequest userRequest) {
        OidcUser user = super.loadUser(userRequest);
        Map<String, Object> oidcClaims = userRequest.getIdToken().getClaims();
        String userNameAttributeName = userRequest.getClientRegistration()
                .getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();

        List<GrantedAuthority> authorities = this.claimsToGrantedAuthoritiesPolicy.claimsToGrantedAuthorities(oidcClaims);

        OidcUser updatedUser;
        if (StringUtils.hasText(userNameAttributeName)) {
            updatedUser = new CustomOidcUser(authorities, userRequest.getIdToken(), user.getUserInfo(), userNameAttributeName);
        } else {
            updatedUser = new CustomOidcUser(authorities, userRequest.getIdToken(), user.getUserInfo());
        }

        return updatedUser;
    }
}
