package com.xebialabs.platform.sso.oidc.web;

import java.io.IOException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

import static com.xebialabs.deployit.booter.local.utils.Strings.isNotEmpty;

public class OidcLogoutSuccessHandler extends SimpleUrlLogoutSuccessHandler {

    private final String defaultLogoutLocation;

    private final CustomOidcClientInitiatedLogoutSuccessHandler logoutSuccessHandler;

    public OidcLogoutSuccessHandler(final ClientRegistrationRepository clientRegistrationRepository,
                                    final String postLogoutRedirectUri,
                                    final String defaultLogoutLocation) {
        this.logoutSuccessHandler = new CustomOidcClientInitiatedLogoutSuccessHandler(clientRegistrationRepository);
        if (isNotEmpty(postLogoutRedirectUri)) {
            this.logoutSuccessHandler.setPostLogoutRedirectUri(postLogoutRedirectUri);
        }
        this.defaultLogoutLocation = defaultLogoutLocation;
    }

    @Override
    public void onLogoutSuccess(final HttpServletRequest request, final HttpServletResponse response,
                                final Authentication authentication) throws IOException, ServletException {
        if (authentication == null || authentication instanceof OAuth2AuthenticationToken) {
            logoutSuccessHandler.onLogoutSuccess(request, response, authentication);
        } else {
            response.sendRedirect(defaultLogoutLocation);
        }
    }
}
