/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.platform.sso.oidc;

/**
 * Enumeration of the available values from OpenId Connect responses.
 */
public enum OpenIdConnectProperty {
    ID_TOKEN_HINT("id_token_hint"),
    ID_TOKEN("id_token"),
    AUDIENCE("aud"),
    ISSUER("iss"),
    EXPIRATION("exp");

    private final String propertyName;

    OpenIdConnectProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return propertyName;
    }
}
