package com.xebialabs.platform.sso.oidc.policy;

import java.util.Map;

import com.xebialabs.platform.sso.oidc.exceptions.InsufficientClaimsException;

/**
 * Policy to convert OIDC claims to a username.
 * <p>
 * See: http://openid.net/specs/openid-connect-core-1_0.html#StandardClaims
 */
public interface ClaimsToUserNamePolicy {
    /**
     * Derive the user name from the claims provided by the IDP.
     * <p>
     * The user name must be all lower case, to prevent issues with duplicate UserProfile.
     *
     * @param oidcClaims a map with the claims (Values can be strings, integers, ..)
     * @return the username
     * @throws InsufficientClaimsException if the necessary information is not present. Probably the case if the OIDC provider is not properly configured.
     */
    String claimsToUserName(Map<String, Object> oidcClaims);
}
