package com.xebialabs.platform.sso.oidc.userdetails;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class OpenIdConnectUserDetails implements UserDetails {
    private final String username;
    private final Map<String, Object> claims;
    private final List<? extends GrantedAuthority> authorities;

    private final String idToken;

    public OpenIdConnectUserDetails(
            String username, Map<String, Object> claims,
            List<? extends GrantedAuthority> authorities,
            String idToken) {
        this.username = username;
        this.claims = claims;
        this.authorities = authorities;
        this.idToken = idToken;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return authorities;
    }

    @Override
    public String getPassword() {
        return "";
    }

    @Override
    public String getUsername() {
        return username;
    }

    public String getIdToken() {
        return idToken;
    }

    @Override
    public boolean isAccountNonExpired() {
        return true;
    }

    @Override
    public boolean isAccountNonLocked() {
        return true;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public Map<String, Object> getClaims() {
        return claims;
    }
}
