/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xlplatform.coc.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import org.joda.time.DateTime;

import java.io.Serializable;

/**
 * A DTO for SCM (source control management) Traceability data
 */
@PublicApiRef
public class SCMTraceabilityData implements Serializable {
    private String kind;
    private String commit;
    private String author;
    private DateTime date;
    private String message;
    private String remote;
    private String fileName;

    public SCMTraceabilityData() {
    }

    public SCMTraceabilityData(String kind, String commit, String author, DateTime date, String message, String remote, String fileName) {
        this.kind = kind;
        this.commit = commit;
        this.author = author;
        this.date = date;
        this.message = message;
        this.remote = remote;
        this.fileName = fileName;
    }

    /**
     * Get a kind of version control system (like git, svn e.t.c.)
     * @return a String
     */
    public String getKind() {
        return kind;
    }

    /**
     * Get a commit identifier
     * @return a String
     */
    public String getCommit() {
        return commit;
    }

    /**
     * Get an author of commit
     * @return a String
     */
    public String getAuthor() {
        return author;
    }

    /**
     * Get a date of commit
     * @return a DateTime
     */
    public DateTime getDate() {
        return date;
    }

    /**
     * Get a commit message
     * @return a String
     */
    public String getMessage() {
        return message;
    }

    /**
     * Get a remote
     * @return a String
     */
    public String getRemote() {
        return remote;
    }

    /**
     * Get a file name
     * @return a String
     */
    public String getFileName() {
        return fileName;
    }
}
