package com.xebialabs.xlplatform.coc.service

import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData

case class PersistenceParams(traceabilityId: Option[Integer],
                             scmTraceabilityData: Option[SCMTraceabilityData])

trait SCMTraceabilityService {
  def getById(id: Integer): Option[SCMTraceabilityData]
  protected def insert(scmTraceabilityData: SCMTraceabilityData): Option[Integer]
  protected def update(traceabilityId: Integer, scmData: SCMTraceabilityData): Option[Integer]
  protected def delete(id: Integer): Option[Integer]

  def persistOrDelete(persistenceParams: PersistenceParams): Option[Integer] = {
    persistenceParams match {
      case PersistenceParams(Some(traceabilityId), Some(data)) => update(traceabilityId, data)
      case PersistenceParams(Some(traceabilityId), None) => delete(traceabilityId)
      case PersistenceParams(None, Some(data)) => insert(data)
      case _ => None
    }
  }
}
