/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xlplatform.endpoints

import org.springframework.security.authentication.UsernamePasswordAuthenticationToken
import org.springframework.security.core.authority.SimpleGrantedAuthority
import org.springframework.security.core.Authentication

import collection.convert.wrapAll._

case class AuthenticatedData(username: String, roles: Seq[String]) {
  def toAuthentication: Authentication = new UsernamePasswordAuthenticationToken(username, "", roles.map(new SimpleGrantedAuthority(_)))
}

object AuthenticatedData {
  def apply(auth: Authentication): AuthenticatedData = AuthenticatedData(auth.getName, auth.getAuthorities.map(_.getAuthority).toSeq)
  def apply(username: String): AuthenticatedData = AuthenticatedData(username, Seq())
}
