package com.xebialabs.xlplatform.endpoints.json

import com.xebialabs.deployit.core.{ListOfStringView, MapStringStringView, SetOfStringView}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import org.apache.pekko.http.scaladsl.marshallers.sprayjson.SprayJsonSupport
import org.python.core.{PyException, PyNone}
import spray.json._

import scala.jdk.CollectionConverters._

trait ScriptResponseProtocol extends DefaultJsonProtocol with SprayJsonSupport with CiJsonProtocol with PasswordEncrypterProvider {

  implicit var ciSerializer: ConfigurationItemFormat = new ConfigurationItemFormat(10)

  implicit object ThrowableFormat extends RootJsonFormat[Option[Throwable]] {
    def write(obj: Option[Throwable]): JsValue = obj match {
      case None =>
        JsNull
      case Some(e: PyException) if e.isInstanceOf[PyException] && e.value != null && !e.value.isInstanceOf[PyNone] =>
        JsString(e.value.toString)
      case Some(e) if e.isInstanceOf[PyException] =>
        JsString(s"Exception of type ${e.getClass.getSimpleName} happened")
      case Some(e: Throwable) =>
        JsString(e.getMessage)
    }
    def read(json: JsValue): Option[Throwable] = None
  }

  implicit object AnyJsonFormat extends JsonFormat[Any] {
    def write(x: Any): JsValue = x match {
      case n: Int => JsNumber(n)
      case n: Double => JsNumber(n)
      case n: java.lang.Double => JsNumber(n)
      case d: java.util.Date => JsNumber(d.getTime)
      case s: String => JsString(s)
      case x: Seq[_] => seqFormat[Any].write(x)
      case x: ListOfStringView => x.getWrapped.asScala.toList.toJson(listFormat(StringValueFormat))
      case x: SetOfStringView => x.getWrapped.asScala.toList.toJson(listFormat(StringValueFormat))
      case x: MapStringStringView => x.getWrapped.asScala.toMap.toJson(mapFormat(DefaultJsonProtocol.StringJsonFormat, StringValueFormat))
      case x: java.util.List[_] => seqFormat[Any].write(x.asScala.toSeq)
      case x: java.util.Map[_, _] => mapFormat[Any, Any].write(x.asScala.toMap)
      case m: Map[_, _] => m.map({
        case (key, value) => (Option(key).map(_.toString).getOrElse("null").toJson, value.asInstanceOf[Any].toJson)
      }).toJson
      case b: Boolean if b => JsTrue
      case b: Boolean if !b => JsFalse
      case null => JsNull
      case ci: ConfigurationItem => ci.toJson
      case _ => serializationError(s"Do not understand object of type ${x.getClass.getName}")
    }

    def read(value: JsValue): Any = ???
  }

  implicit val scriptResponseFormat: RootJsonFormat[ScriptResponse] = jsonFormat4(ScriptResponse.apply)

}
