package com.xebialabs.xlplatform.endpoints.servlet

import com.typesafe.config.Config
import com.xebialabs.xlplatform.pekko.Pekko
import grizzled.slf4j.Logging

import jakarta.servlet.{ServletContext, ServletContextEvent, ServletContextListener}

class PekkoStreamServletInitializer(val config: Config) extends ServletContextListener with Logging {
  import PekkoStreamServletInitializer._
  private var boot: ServletBoot = _

  def this() = this(null)

  override def contextInitialized(sce: ServletContextEvent): Unit = {
    val ctx: ServletContext = sce.getServletContext
    logger.debug("Initializing PekkoStream servlet context")
    boot = new ServletBoot(config)

    ctx.setAttribute(SYSTEM_KEY, boot.system)
    ctx.setAttribute(ROUTES_KEY, boot.routes)
    ctx.setAttribute(TIMEOUT_KEY, boot.settings.ServerExtension.timeout.duration.toMillis)
  }

  override def contextDestroyed(sce: ServletContextEvent): Unit = {
    logger.debug("Terminating PekkoStream servlet context")
    Pekko.terminate(boot.system)
  }
}

object PekkoStreamServletInitializer {
  val SYSTEM_KEY = "pekko-stream.servlet.system"
  val ROUTES_KEY = "pekko-stream.servlet.routes"
  val TIMEOUT_KEY = "pekko-stream.servlet.timeout"
}

