package com.xebialabs.xlplatform.endpoints.servlet

import com.typesafe.config.Config
import com.xebialabs.deployit.util.PasswordEncrypter
import com.xebialabs.xlplatform.endpoints.ExtendableRestApi
import com.xebialabs.xlplatform.settings.{ExtensionSettings, XlPlatformSettings}
import org.apache.pekko.actor.{ActorRefFactory, ActorSystem}
import org.apache.pekko.http.scaladsl.server.Route

class ServletBoot(val config: Config) extends ExtendableRestApi {
  def this() = this(null)

  val system = ActorSystem("extension-servlet-system", config)
  val actorRefFactory: ActorRefFactory = system

  lazy val settings: XlPlatformSettings = ExtensionSettings(system)
  lazy val passwordEncrypter: PasswordEncrypter = PasswordEncrypter.getInstance()

  lazy val routes: Route = extendableRoutes
}

