package com.xebialabs.xlplatform.jmx

import com.typesafe.config.Config
import com.xebialabs.xlplatform.settings.{SecuritySettings, SettingsSupport}

class JMXSettings(val config: Config) extends SettingsSupport {
  import SettingsSupport._
  lazy val enabled: Boolean = valueWithDefault[Boolean]("xl.jmx.enabled", false)
  lazy val hostname: String = value[String]("xl.jmx.hostname")
  lazy val port: Int = value[Int]("xl.jmx.port")
  lazy val ssl: SecuritySettings = new SecuritySettings(config.getConfig("xl.jmx.ssl"))
}
