package com.xebialabs.license.service.aws

import com.xebialabs.license.service.LicenseConfig
import org.apache.http.HttpResponse
import org.apache.http.client.{HttpClient, ResponseHandler}
import org.apache.http.client.config.RequestConfig
import org.apache.http.impl.client.HttpClientBuilder
import org.apache.http.util.EntityUtils

trait HttpClientAware {
  val licenseConfig: LicenseConfig

  private[aws] def requestConfig: RequestConfig

  private[aws] def getHttpClient(): HttpClient = {
    HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build()
  }

  private[aws] def responseHandler(): ResponseHandler[Option[String]] = {
    (response: HttpResponse) => {
      val status = response.getStatusLine.getStatusCode
      if (status >= 200 && status < 300) {
        val entity = response.getEntity
        if (entity != null) Some(EntityUtils.toString(entity))
        else None
      }
      else None
    }
  }

}
