package com.xebialabs.license;

import java.util.ArrayList;
import java.util.List;

/**
 * When user tries to start the application without using any license, dummy license to be used to be able to run the server.
 */
public class DummyLicense extends License {

    private DummyLicense(LicensePropertyMap values) throws LicenseViolationException {
        super(values);
    }

    public static DummyLicense create() {
        try {
            return new DummyLicense(new LicensePropertyMap());
        } catch (LicenseViolationException e) {
            throw new RuntimeException("Unable to create bootstrap license", e);
        }
    }

    @Override
    public List<LicenseProperty> getLicenseProperties() {
        return new ArrayList<>();
    }

    @Override
    public List<LicenseProperty> getRequiredProperties() {
        return new ArrayList<>();
    }

    @Override
    public int getLicenseVersion() {
        return -1;
    }

    @Override
    public void validateLicenseFormat() {

    }

    @Override
    public boolean isAtLeastVersion(int minimumLicenseVersion) {
        return true;
    }

    @Override
    public boolean isDummyLicense() {
        return true;
    }
}
