package com.xebialabs.license;

import org.bouncycastle.util.encoders.HexEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

import static org.apache.commons.codec.binary.Base64.decodeBase64;

public class LicenseUtils {
    private final static Logger logger = LoggerFactory.getLogger(LicenseUtils.class);

    private LicenseUtils() {
    }

    public static byte[] readKey(String data) throws IOException {
        HexEncoder hexit = new HexEncoder();

        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        hexit.decode(data, bos);

        return bos.toByteArray();
    }

    public static boolean isBase64License(String licenseText) {
        //Base 64 never contains - or :, a license always contains - and :.

        if (licenseText.contains("-") && licenseText.contains(":")) {
            return false;
        }
        if (!licenseText.contains("-") && !licenseText.contains(":")) {
            return true;
        }
        logger.warn("licenseText {} does not contain a - and a :, which is invalid");
        return false;
    }

    public static String decodeBase64License(final String data) {
        final String decoded;
        final String whitespaceRegex = "[\u2002\u3000\r\u0085\u200A\u2005\u2000\u3000"
                + "\u2029\u000B\u3000\u2008\u2003\u205F\u3000\u1680"
                + "\u0009\u0020\u2006\u2001\u202F\u00A0\u000C\u2009"
                + "\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000]";
        String stripped = data.replaceAll(whitespaceRegex, "");
        try {
            decoded = new String(decodeBase64(stripped), StandardCharsets.UTF_8).replaceAll("\\r\\n?", "\n");
        } catch (IllegalArgumentException iae) {
            Throwable cause = iae.getCause();
            if (cause != null) {
                throw new LicenseParseException(data, cause.getMessage());
            } else {
                throw new LicenseParseException(data, "Parsing license text failed", iae);
            }
        }
        return decoded;
    }

    public static String decodeIfNecessary(String text) {
        if (isBase64License(text)) {
            return decodeBase64License(text);
        }
        return text;
    }
}
