/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service.aws;

import com.amazonaws.services.marketplacemetering.AWSMarketplaceMetering;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseVerificationException;
import com.xebialabs.license.service.BaseLicenseService;
import com.xebialabs.license.service.LicenseCiCounterFactory;
import com.xebialabs.license.service.LicenseConfig;
import com.xebialabs.license.service.LicenseConfig$License$AWSLicenseConfig$;
import com.xebialabs.license.service.aws.AWSLicenseEndpoint;
import com.xebialabs.license.service.aws.AWSMetering;
import com.xebialabs.license.service.aws.LicenseAWSNonceException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.UUID;
import org.joda.time.Period;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u001b\tA\u0012iV*NKR,'/\u001a3MS\u000e,gn]3TKJ4\u0018nY3\u000b\u0005\r!\u0011aA1xg*\u0011QAB\u0001\bg\u0016\u0014h/[2f\u0015\t9\u0001\"A\u0004mS\u000e,gn]3\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u00011\u0003\u0002\u0001\u000f%Y\u0001\"a\u0004\t\u000e\u0003\u0011I!!\u0005\u0003\u0003%\t\u000b7/\u001a'jG\u0016t7/Z*feZL7-\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u00111\"Q,T\u001b\u0016$XM]5oOB\u00111cF\u0005\u00031\t\u0011!#Q,T\u0019&\u001cWM\\:f\u000b:$\u0007o\\5oi\"A!\u0004\u0001BC\u0002\u0013\u00051$A\u0007mS\u000e,gn]3D_:4\u0017nZ\u000b\u00029A\u0011q\"H\u0005\u0003=\u0011\u0011Q\u0002T5dK:\u001cXmQ8oM&<\u0007\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u001d1L7-\u001a8tK\u000e{gNZ5hA!)!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001J\u0013\u0011\u0005M\u0001\u0001\"\u0002\u000e\"\u0001\u0004a\u0002bB\u0004\u0001\u0001\u0004%\taJ\u000b\u0002QA\u0019\u0011\u0006\f\u0018\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012aa\u00149uS>t\u0007CA\u00181\u001b\u00051\u0011BA\u0019\u0007\u0005\u001da\u0015nY3og\u0016Dqa\r\u0001A\u0002\u0013\u0005A'A\u0006mS\u000e,gn]3`I\u0015\fHCA\u001b9!\tIc'\u0003\u00028U\t!QK\\5u\u0011\u001dI$'!AA\u0002!\n1\u0001\u001f\u00132\u0011\u0019Y\u0004\u0001)Q\u0005Q\u0005AA.[2f]N,\u0007\u0005C\u0004>\u0001\t\u0007I\u0011\t \u0002\u000b9|gnY3\u0016\u0003}\u0002\"\u0001Q$\u000f\u0005\u0005+\u0005C\u0001\"+\u001b\u0005\u0019%B\u0001#\r\u0003\u0019a$o\\8u}%\u0011aIK\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002GU!11\n\u0001Q\u0001\n}\naA\\8oG\u0016\u0004\u0003BB'\u0001A\u0013%a*\u0001\fhKR|%/\u001b8ji&\fG.\u001b>f\u0019&\u001cWM\\:f+\u0005q\u0003\"\u0002)\u0001\t\u0003\n\u0016AC4fi2K7-\u001a8tKR\ta\u0006C\u0003T\u0001\u0011\u0005C+\u0001\tjg2K7-\u001a8tK\u0016C\b/\u001b:fIR\tQ\u000b\u0005\u0002*-&\u0011qK\u000b\u0002\b\u0005>|G.Z1o\u0011\u0015I\u0006\u0001\"\u0011[\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0003kmCQ\u0001\u0018-A\u0002u\u000b\u0001cY5D_VtG/\u001a:GC\u000e$xN]=\u0011\u0005=q\u0016BA0\u0005\u0005]a\u0015nY3og\u0016\u001c\u0015nQ8v]R,'OR1di>\u0014\u0018\u0010C\u0003b\u0001\u0011\u0005#-\u0001\bhKR4\u0016\r\\5e!\u0016\u0014\u0018n\u001c3\u0015\u0003\r\u0004\"\u0001Z6\u000e\u0003\u0015T!AZ4\u0002\tQLW.\u001a\u0006\u0003Q&\fAA[8eC*\t!.A\u0002pe\u001eL!\u0001\\3\u0003\rA+'/[8e\u0011\u0015q\u0007\u0001\"\u0011p\u0003)9W\r\u001e)s_\u0012,8\r\u001e\u000b\u0002\u007f!)\u0011\u000f\u0001C!e\u00061!/\u001a7pC\u0012$\u0012!\u000e\u0005\u0006i\u0002!\t%^\u0001\tm\u0006d\u0017\u000eZ1uKR\u0011QG\u001e\u0005\u0006\u000fM\u0004\rA\f")
public class AWSMeteredLicenseService
extends BaseLicenseService
implements AWSMetering,
AWSLicenseEndpoint {
    private final LicenseConfig licenseConfig;
    private Option<License> license;
    private final String nonce;
    private final LicenseConfig$License$AWSLicenseConfig$ com$xebialabs$license$service$aws$AWSMetering$$aws;
    private AWSMarketplaceMetering com$xebialabs$license$service$aws$AWSMetering$$meteredService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile byte bitmap$0;

    @Override
    public void validateProductCode(String productCode) {
        AWSLicenseEndpoint.validateProductCode$(this, productCode);
    }

    @Override
    public AWSLicenseEndpoint.AWSLicense retrieveLicense(String productCode, String nonce, String product) {
        return AWSLicenseEndpoint.retrieveLicense$(this, productCode, nonce, product);
    }

    @Override
    public void registerUsage() {
        AWSMetering.registerUsage$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public LicenseConfig$License$AWSLicenseConfig$ com$xebialabs$license$service$aws$AWSMetering$$aws() {
        return this.com$xebialabs$license$service$aws$AWSMetering$$aws;
    }

    private AWSMarketplaceMetering com$xebialabs$license$service$aws$AWSMetering$$meteredService$lzycompute() {
        AWSMeteredLicenseService aWSMeteredLicenseService = this;
        synchronized (aWSMeteredLicenseService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.com$xebialabs$license$service$aws$AWSMetering$$meteredService = AWSMetering.com$xebialabs$license$service$aws$AWSMetering$$meteredService$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.com$xebialabs$license$service$aws$AWSMetering$$meteredService;
    }

    @Override
    public AWSMarketplaceMetering com$xebialabs$license$service$aws$AWSMetering$$meteredService() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.com$xebialabs$license$service$aws$AWSMetering$$meteredService$lzycompute() : this.com$xebialabs$license$service$aws$AWSMetering$$meteredService;
    }

    @Override
    public final void com$xebialabs$license$service$aws$AWSMetering$_setter_$com$xebialabs$license$service$aws$AWSMetering$$aws_$eq(LicenseConfig$License$AWSLicenseConfig$ x$1) {
        this.com$xebialabs$license$service$aws$AWSMetering$$aws = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        AWSMeteredLicenseService aWSMeteredLicenseService = this;
        synchronized (aWSMeteredLicenseService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public LicenseConfig licenseConfig() {
        return this.licenseConfig;
    }

    public Option<License> license() {
        return this.license;
    }

    public void license_$eq(Option<License> x$1) {
        this.license = x$1;
    }

    @Override
    public String nonce() {
        return this.nonce;
    }

    private License getOrinitializeLicense() {
        License license;
        Option<License> option = this.license();
        if (option instanceof Some) {
            Some some = (Some)option;
            License l = (License)some.value();
            this.validate(l);
            license = l;
        } else if (None$.MODULE$.equals(option)) {
            this.validateProductCode(this.licenseConfig().license().aws().productCode());
            this.registerUsage();
            License newLicense = this.retrieveLicense(this.licenseConfig().license().aws().productCode(), this.nonce(), this.licenseConfig().license().productName()).asLicense();
            this.validate(newLicense);
            this.license_$eq((Option<License>)new Some((Object)newLicense));
            license = (License)this.license().get();
        } else {
            throw new MatchError(option);
        }
        return license;
    }

    public License getLicense() {
        return this.getOrinitializeLicense();
    }

    public boolean isLicenseExpired() {
        return this.license().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDateExpired()));
    }

    public void initialize(LicenseCiCounterFactory ciCounterFactory) {
        this.ciCounterFactory = ciCounterFactory;
        this.reLoadCiCounter(this.getOrinitializeLicense());
    }

    public Period getValidPeriod() {
        return Period.months((int)1);
    }

    public String getProduct() {
        return (String)this.license().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getStringValue(LicenseProperty.PRODUCT)).get();
    }

    public void reload() {
        License l = this.getOrinitializeLicense();
        this.reLoadCiCounter(l);
        this.validate();
    }

    @Override
    public void validate(License license) {
        if (!license.hasLicenseProperty(LicenseProperty.AWS_NONCE)) {
            throw new LicenseVerificationException("The current license does not have the '" + LicenseProperty.AWS_NONCE + "' property set.");
        }
        if (!license.getStringValue(LicenseProperty.AWS_NONCE).equals(this.nonce())) {
            throw new LicenseAWSNonceException("The current license is for a different instance than your own.");
        }
        super.validate(license);
    }

    public AWSMeteredLicenseService(LicenseConfig licenseConfig) {
        this.licenseConfig = licenseConfig;
        Logging.$init$((Logging)this);
        AWSMetering.$init$(this);
        AWSLicenseEndpoint.$init$(this);
        this.license = None$.MODULE$;
        this.nonce = UUID.randomUUID().toString();
    }
}

