package com.xebialabs.license.service;

import java.io.File;

import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.license.*;

/**
 * This service have to be used in the case when you want to allow to run the server without any license
 * and redirect the user to the registration form.
 */
public class RegistrationLicenseService extends AbstractLicenseService implements LicenseService {

    private final LicenseReader licenseReader = new LicenseReader();

    public RegistrationLicenseService(String licensePath, String product, RepositoryMetadataService repositoryMetadataService) throws LicenseParseException,
            LicenseViolationException {
        super(licensePath, product, repositoryMetadataService);

        license = readLicense(licenseFile);

        if (license.isDateExpired()) {
            logLicenseError(licenseFile);
        }
    }

    protected License readLicense(File licenseFile) throws LicenseParseException, LicenseViolationException {
        String licenseFilePath = licenseFile.getAbsolutePath();
        if (!licenseFile.exists()) {
            return DummyLicense.create();
        }

        log.info("Reading license from file {}", licenseFilePath);
        License license = licenseReader.readLicense(licenseFile);
        log.info(license.toLicenseContent());

        if (license.isDateExpired()) {
            log.warn("*** License has expired.");
        }

        return license;
    }
}
