package com.xebialabs.license.service.aws

import java.util.UUID

import com.xebialabs.license.{License, LicenseProperty, LicenseVerificationException, LicenseViolationException}
import com.xebialabs.license.service.{BaseLicenseService, LicenseCiCounterFactory, LicenseConfig}
import org.joda.time.Period

class AWSMeteredLicenseService(val licenseConfig: LicenseConfig) extends BaseAWSLicenseService with AWSMetering with AWSLicenseEndpoint {
  override val nonce: String = UUID.randomUUID().toString

  def getOrinitializeLicense = {
    license match {
      case Some(l) =>
        validate(l)
        l
      case None =>
        validateProductCode(licenseConfig.license.aws.productCode)
        registerUsage()
        val newLicense = retrieveLicense(licenseConfig.license.aws.productCode, nonce, licenseConfig.license.productName).asLicense()
        validate(newLicense)
        license = Some(newLicense)
        license.get
    }
  }

  override def validate(license: License): Unit = {
    if (!license.hasLicenseProperty(LicenseProperty.AWS_NONCE)) {
      throw new LicenseVerificationException("The current license does not have the '" + LicenseProperty.AWS_NONCE + "' property set.")
    } else if (!license.getStringValue(LicenseProperty.AWS_NONCE).equals(nonce)) {
      throw LicenseAWSNonceException("The current license is for a different instance than your own.")
    }
    super.validate(license)
  }
}

case class LicenseAWSNonceException(msg: String) extends LicenseViolationException(msg)