package com.xebialabs.license.service

import com.typesafe.config.{Config, ConfigFactory}

case class LicenseConfig(config: Config) {
  import com.xebialabs.xlplatform.settings.SettingsSupport._

  val license = License

  object License {
    private[this] lazy val licenseConfig: Config = config.valueWithDefault[Config]("xl.license", config)
    lazy val licenseService = licenseConfig.valueWithDefault[String]("kind", "byol")
    lazy val endpoint = licenseConfig.value[String]("endpoint")
    lazy val productName = licenseConfig.value[String]("product")

    lazy val aws = AWSLicenseConfig

    object AWSLicenseConfig {
      private[this] lazy val aws = licenseConfig.valueWithDefault[Config]("aws", ConfigFactory.empty())
      lazy val productCode = aws.value[String]("productCode")
      lazy val publicKeyVersion = aws.value[Int]("publicKeyVersion")
      lazy val publicKey = aws.value[String]("publicKey")
    }

    lazy val ami = AWSAmiLicenseConfig
    object AWSAmiLicenseConfig {
      private[this] lazy val ami = licenseConfig.valueWithDefault[Config]("ami", ConfigFactory.empty())
      lazy val productCode = ami.value[String]("productCode")
      lazy val metadataEndpoint = ami.valueWithDefault[String]("metadataEndpoint", "http://169.254.169.254/latest")
      lazy val identityDocument = ami.valueWithDefault[String]("identityDocument", "/dynamic/instance-identity/document")
      lazy val identityDocumentSignature = ami.valueWithDefault[String]("identityDocumentSignature", "/dynamic/instance-identity/pkcs7")
      lazy val connectTimeout = ami.valueWithDefault[Int]("connectTimeout", 5000)
      lazy val awsCertificate = ami.valueWithDefault[String]("certificate",
        """
          |-----BEGIN X509 CERTIFICATE-----
          |MIIC7TCCAq0CCQCWukjZ5V4aZzAJBgcqhkjOOAQDMFwxCzAJBgNVBAYTAlVTMRkwFwYDVQQIExBXYXNoaW5ndG9uIFN0YXRlMRAwDgYDVQQHEwdTZWF0dGxlMSAwHgYDVQQKExdBbWF6b24gV2ViIFNlcnZpY2VzIExMQzAeFw0xMjAxMDUxMjU2MTJaFw0zODAxMDUxMjU2MTJaMFwxCzAJBgNVBAYTAlVTMRkwFwYDVQQIExBXYXNoaW5ndG9uIFN0YXRlMRAwDgYDVQQHEwdTZWF0dGxlMSAwHgYDVQQKExdBbWF6b24gV2ViIFNlcnZpY2VzIExMQzCCAbcwggEsBgcqhkjOOAQBMIIBHwKBgQCjkvcS2bb1VQ4yt/5eih5OO6kK/n1Lzllr7D8ZwtQP8fOEpp5E2ng+D6Ud1Z1gYipr58Kj3nssSNpI6bX3VyIQzK7wLclnd/YozqNNmgIyZecN7EglK9ITHJLP+x8FtUpt3QbyYXJdmVMegN6PhviYt5JH/nYl4hh3Pa1HJdskgQIVALVJ3ER11+Ko4tP6nwvHwh6+ERYRAoGBAI1jk+tkqMVHuAFcvAGKocTgsjJem6/5qomzJuKDmbJNu9Qxw3rAotXau8Qe+MBcJl/Uhhy1KHVpCGl9fueQ2s6IL0CaO/buycU1CiYQk40KNHCcHfNiZbdlx1E9rpUp7bnFlRa2v1ntMX3caRVDdbtPEWmdxSCYsYFDk4mZrOLBA4GEAAKBgEbmeve5f8LIE/GfMNmP9CM5eovQOGx5ho8WqD+aTebs+k2tn92BBPqeZqpWRa5P/+jrdKml1qx4llHWMXrs3IgIb6+hUIB+S8dz8/mmO0bpr76RoZVCXYab2CZedFut7qc3WUH9+EUAH5mwvSeDCOUMYQR7R9LINYwouHIziqQYMAkGByqGSM44BAMDLwAwLAIUWXBlk40xTwSw7HX32MxXYruse9ACFBNGmdX2ZBrVNGrN9N2f6ROk0k9K
          |-----END X509 CERTIFICATE-----
          |""".stripMargin)
    }

  }
}
