package com.xebialabs.license.service.aws

import com.xebialabs.license.License
import com.xebialabs.license.service.LicenseConfig

import scala.util.{Success, Try}

class AWSAmiLicenseService(val licenseConfig: LicenseConfig) extends BaseAWSLicenseService with AWSAmiMarketplace with AWSLicenseEndpoint {
  override def getOrinitializeLicense: License = license match {
    case Some(l) =>
      validate(l)
      l
    case None =>
      val pcs = getProductCodes
      val tpcs = pcs.map({ pc =>
        Try(validateProductCode(pc))
      })

      tpcs.collectFirst({ case Success(pc) =>
        val newLicense = retrieveLicense(pc, nonce, licenseConfig.license.productName).asLicense()
        validate(newLicense)
        license = Some(newLicense)
        newLicense
      }).getOrElse(throw AWSLicenseException(tpcs.foldLeft("") { case (s, ex) => ex.fold(t => s"$s\n${t.getMessage}", _ => s) }))
  }
}
