package com.xebialabs.license.service

import com.typesafe.config.Config
import com.xebialabs.deployit.io.ConfigurationResource
import com.xebialabs.deployit.repository.RepositoryMetadataService
import com.xebialabs.license.service.aws.{AWSAmiLicenseService, AWSMeteredLicenseService}

class LicenseServiceFactory(repositoryMetadataService: RepositoryMetadataService,
                            licenseCiCounterFactory: LicenseCiCounterFactory,
                            config: Config,
                            licenseFile: String,
                            product: String) {
  def createLicenseService(): LicenseService = {

    val ls = LicenseConfig(config).license.licenseService match {
      case "byol" =>
        new RegistrationLicenseService(licenseFile, product, repositoryMetadataService)
      case "aws" =>
        new AWSMeteredLicenseService(LicenseConfig(config))
      case "ami" =>
        new AWSAmiLicenseService(LicenseConfig(config))
    }
    ls.initialize(licenseCiCounterFactory)
    ls
  }
}

class ResourceLicenseServiceFactory(repositoryMetadataService: RepositoryMetadataService,
                                    licenseCiCounterFactory: LicenseCiCounterFactory,
                                    config: Config,
                                    licenseResource: ConfigurationResource,
                                    product: String) {
  def createLicenseService(): LicenseService = {

    val ls = LicenseConfig(config).license.licenseService match {
      case "byol" =>
        new ResourceRegistrationLicenseService(licenseResource, product, repositoryMetadataService)
      case "aws" =>
        new AWSMeteredLicenseService(LicenseConfig(config))
      case "ami" =>
        new AWSAmiLicenseService(LicenseConfig(config))
    }
    ls.initialize(licenseCiCounterFactory)
    ls
  }
}