package com.xebialabs.license.service;

import com.xebialabs.deployit.io.ConfigurationResource;
import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.license.*;

import java.io.IOException;

/**
 * This service have to be used in the case when you want to allow to run the server without any license
 * and redirect the user to the registration form.
 */
public class ResourceRegistrationLicenseService extends AbstractResourceLicenseService implements LicenseService {

    private final LicenseReader licenseReader = new LicenseReader();

    public ResourceRegistrationLicenseService(ConfigurationResource licenseResource,
                                              String product,
                                              RepositoryMetadataService repositoryMetadataService) throws LicenseParseException,
            LicenseViolationException, IOException {
        super(licenseResource, product, repositoryMetadataService);

        license = readLicense(licenseResource);

        if (license.isDateExpired()) {
            logLicenseError(licenseResource);
        }
    }

    protected License readLicense(ConfigurationResource licenseResource) throws LicenseParseException, LicenseViolationException {
        try {
            if (!licenseResource.exists()) {
                return DummyLicense.create();
            }

            log.info("Reading license from file {}", licenseResource.getUrl());
            License license = licenseReader.readLicense(licenseResource);
            log.info(license.toLicenseContent());

            if (license.isDateExpired()) {
                log.warn("*** License has expired.");
            }

            return license;
        } catch(IOException e) {
            throw new LicenseParseException(e.getMessage(), e);
        }
    }
}
