package com.xebialabs.license.service.aws

import com.xebialabs.license.service.LicenseConfig
import org.apache.hc.core5.http.{HttpResponse, HttpStatus}
import org.apache.hc.core5.http.io.entity.EntityUtils
import org.apache.hc.client5.http.impl.classic.{CloseableHttpClient, HttpClients}
import org.apache.hc.client5.http.config.RequestConfig
import org.apache.hc.core5.http.io.HttpClientResponseHandler
import org.apache.hc.core5.http.ClassicHttpResponse;

trait HttpClientAware {
  val licenseConfig: LicenseConfig

  private[aws] def requestConfig: RequestConfig

  private[aws] def getHttpClient(): CloseableHttpClient = {
    HttpClients.custom().setDefaultRequestConfig(requestConfig).build()
  }

  private[aws] def responseHandler(): HttpClientResponseHandler[Option[String]] = {
    (response: HttpResponse) => {
      val status = response.getCode
      if (status >= HttpStatus.SC_SUCCESS && status < HttpStatus.SC_REDIRECTION) {
        val entity = response match {
          case classicResponse: ClassicHttpResponse => classicResponse.getEntity
          case _ => null // or handle accordingly
        }
        if (entity != null) {
          Some(EntityUtils.toString(entity))
        } else None
      } else None
    }
  }
}
