package com.xebialabs.license.service

import com.typesafe.config.Config

case class LicenseConfig(config: Config) {

  import com.xebialabs.xlplatform.settings.SettingsSupport._

  val license = License

  object License {
    private[this] lazy val licenseConfig: Config = config.valueWithDefault[Config]("xl.license", config)
    lazy val licenseService = licenseConfig.valueWithDefault[String]("kind", "byol")
    lazy val endpoint = licenseConfig.value[String]("endpoint")
    lazy val productName = licenseConfig.value[String]("product")
  }
}
