package com.xebialabs.license.service;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.license.LicenseCiCounter;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLicenseService implements LicenseService {
    private static final Logger log = LoggerFactory.getLogger(BaseLicenseService.class);

    protected LicenseCiCounter ciCounter;
    protected LicenseCiCounterFactory ciCounterFactory = new DefaultLicenseCiCounterFactory();

    public void initialize(LicenseCiCounterFactory ciCounterFactory, License license) {
        this.ciCounterFactory = ciCounterFactory;
        reLoadCiCounter(license);
    }

    @Override
    public LicenseCiCounter getCounter() {
        if (ciCounter == null) {
            throw new IllegalStateException("ciCounter is null. Did you forget to initialize the license server?");
        }
        return ciCounter;
    }

    protected void reLoadCiCounter(License license) {
        log.debug("Loading license CI counter using current license.");
        ciCounter = ciCounterFactory.create(license);
        log.debug("License CI counter loaded and contains {} restricted CIs.", ciCounter.restrictedTypes().size());
    }



    @Override
    public LicenseTransaction startTransaction() {
        return new LicenseTransaction();
    }

    @Override
    public void rollbackTransaction(final LicenseTransaction transaction) {
        for (Type type : transaction.getCiCountTypes()) {
            ciCounter.rollbackTransaction(type, transaction);
        }
    }

    @Override
    public void validate() throws LicenseViolationException {
        ciCounter.validate();
    }

    @Override
    public void validate(License license) throws LicenseViolationException {
        LicenseCiCounter tmpCiCounter = ciCounterFactory.create(license);
        tmpCiCounter.validate();
    }

}
