/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.sql;

import com.xebialabs.deployit.checksum.DefaultChecksumAlgorithmProviderFactory$;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import com.xebialabs.plugin.manager.Plugin;
import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.config.ConfigWrapper$;
import com.xebialabs.plugin.manager.metadata.Version;
import com.xebialabs.plugin.manager.metadata.Version$;
import com.xebialabs.plugin.manager.metadata.Version$VersionOps$;
import com.xebialabs.plugin.manager.rest.api.PluginSource$;
import com.xebialabs.plugin.manager.rest.api.PluginStatus$;
import com.xebialabs.plugin.manager.sql.DbPlugin;
import java.io.Serializable;
import java.security.MessageDigest;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple10;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DbPlugin$
implements Serializable {
    public static final DbPlugin$ MODULE$ = new DbPlugin$();

    public DbPlugin apply(Plugin plugin) {
        DbPlugin dbPlugin;
        PluginId pluginId = plugin.id();
        if (pluginId instanceof PluginId.Artifact) {
            PluginId.Artifact artifact = (PluginId.Artifact)pluginId;
            dbPlugin = this.fromArtifact(artifact, plugin.content().readAllBytes());
        } else if (pluginId instanceof PluginId.LocalFile) {
            PluginId.LocalFile localFile = (PluginId.LocalFile)pluginId;
            dbPlugin = this.fromLocalFile(localFile, plugin.content().readAllBytes());
        } else {
            throw new IllegalArgumentException("Not a proper plugin for conversion to a dbPlugin");
        }
        return dbPlugin;
    }

    public DbPlugin fromLocalFile(PluginId.LocalFile localFile, byte[] bytes) {
        return new DbPlugin(0L, localFile.basename(), (Option<String>)new Some(localFile.version().map((Function1 & Serializable)v -> Version$VersionOps$.MODULE$.id$extension(Version$.MODULE$.VersionOps((Version)v))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), ConfigWrapper$.MODULE$.extension(), PluginSource$.MODULE$.LOCAL().toString(), PluginStatus$.MODULE$.READY_FOR_INSTALL(), PluginSource$.MODULE$.LOCAL(), this.calculateChecksum(bytes), (Option<Object>)None$.MODULE$, (Option<byte[]>)new Some((Object)bytes));
    }

    public DbPlugin fromArtifact(PluginId.Artifact artifact, byte[] bytes) {
        return new DbPlugin(0L, artifact.artifactId(), (Option<String>)new Some((Object)Version$VersionOps$.MODULE$.id$extension(Version$.MODULE$.VersionOps(artifact.version()))), ConfigWrapper$.MODULE$.extension(), artifact.groupId(), PluginStatus$.MODULE$.READY_FOR_INSTALL(), PluginSource$.MODULE$.withName(artifact.repository()), this.calculateChecksum(bytes), (Option<Object>)None$.MODULE$, (Option<byte[]>)new Some((Object)bytes));
    }

    public String calculateChecksum(byte[] bytes) {
        MessageDigest hash = DefaultChecksumAlgorithmProviderFactory$.MODULE$.defaultComparisonAlgorithm().getMessageDigest();
        hash.update(bytes);
        return JavaCryptoUtils.digest((MessageDigest)hash);
    }

    public DbPlugin DbPluginOps(DbPlugin dbPlugin) {
        return dbPlugin;
    }

    public DbPlugin apply(long id, String name, Option<String> version, String extension, String groupId, Enumeration.Value installationStatus, Enumeration.Value source, String checksum, Option<Object> pluginBytesId, Option<byte[]> bytes) {
        return new DbPlugin(id, name, version, extension, groupId, installationStatus, source, checksum, pluginBytesId, bytes);
    }

    public Option<Tuple10<Object, String, Option<String>, String, String, Enumeration.Value, Enumeration.Value, String, Option<Object>, Option<byte[]>>> unapply(DbPlugin x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple10((Object)BoxesRunTime.boxToLong((long)x$0.id()), (Object)x$0.name(), x$0.version(), (Object)x$0.extension(), (Object)x$0.groupId(), (Object)x$0.installationStatus(), (Object)x$0.source(), (Object)x$0.checksum(), x$0.pluginBytesId(), x$0.bytes()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DbPlugin$.class);
    }

    private DbPlugin$() {
    }
}

