package com.xebialabs.plugin.manager.rest.api

import java.io.InputStream
import javax.ws.rs._
import javax.ws.rs.core.MediaType
import javax.ws.rs.core.MediaType.APPLICATION_JSON

import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource
import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import com.xebialabs.plugin.manager.service.PluginServiceImpl
import com.xebialabs.plugin.manager.{Plugin, PluginMetadata}
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput
import org.springframework.stereotype.Controller

import scala.collection.JavaConverters._

@Path("/plugin-manager")
@Produces(Array(APPLICATION_JSON))
@Controller
class PluginResource extends AbstractSecuredResource {

  val pluginService = new PluginServiceImpl

  @GET
  def list(): java.util.List[PluginMetadata] = {
    checkPermission(ADMIN)
    pluginService.listInstalled().asJava
  }

  @POST
  @Consumes(Array("multipart/form-data"))
  def install(input: MultipartFormDataInput, @QueryParam("pluginId") pluginId: String): Unit = {
    checkPermission(ADMIN)
    val uploadForm = input.getFormDataMap
    val inputParts = uploadForm.get("file")

    inputParts.forEach { part =>
      val is = part.getBody[InputStream](classOf[InputStream], null)
      pluginService.install(Plugin(pluginId, is))
    }
  }

  @DELETE
  @Path("/delete")
  def uninstall(@QueryParam("pluginId") pluginId: String): Unit = {
    checkPermission(ADMIN)
    pluginService.uninstall(PluginMetadata(pluginId))
  }

  @POST
  @Path("/delete")
  @Consumes(Array(MediaType.APPLICATION_JSON))
  def uninstall(pluginIds: java.util.List[String]): Unit = {
    checkPermission(ADMIN)
    pluginIds.asScala.foreach { id =>
      pluginService.uninstall(PluginMetadata(id))
    }

  }

}
