package com.xebialabs.plugin.manager.service

import com.xebialabs.plugin.manager.repository.PluginRepository
import com.xebialabs.plugin.manager.{LocalPluginManager, Plugin, PluginManager, PluginMetadata}

trait PluginService {

  def repositories: Seq[PluginRepository]

  def pluginManager: PluginManager

  def search(): Seq[PluginMetadata]

  def listInstalled(): Seq[PluginMetadata]

  def install(plugin: Plugin)

  def uninstall(metadata: PluginMetadata)

}

class PluginServiceImpl extends PluginService {

  override def repositories: Seq[PluginRepository] = Seq.empty

  override def pluginManager: PluginManager = new LocalPluginManager()

  override def search(): Seq[PluginMetadata] = ???

  override def listInstalled(): Seq[PluginMetadata] = pluginManager.list()

  override def install(plugin: Plugin): Unit = pluginManager.install(plugin)

  override def uninstall(metadata: PluginMetadata): Unit = pluginManager.uninstall(metadata)
}
