package com.xebialabs.plugin.manager

import com.xebialabs.plugin.manager.metadata.ArtifactId

import scala.concurrent.{ExecutionContext, Future}


trait PluginManager {
  implicit val ec: ExecutionContext

  def name: String

  def listInstalled(): Seq[PluginId]

  def install(plugin: Plugin): Unit

  def uninstall(id: PluginId): Boolean

  def search(query: Option[String]): Future[Set[ArtifactId]] = Future.successful {
    val installed = listInstalled().map(_.toArtifactId).toSet
    query match {
      case Some(pluginName) if pluginName.nonEmpty => installed.filter(_.id.contains(pluginName))
      case _ => installed
    }
  }

}