package com.xebialabs.plugin.manager.rest.json

import com.xebialabs.plugin.manager.rest.api.ValidationResult
import org.springframework.stereotype.Component
import spray.json.{DefaultJsonProtocol, JsObject, JsString}

import java.io.{IOException, OutputStream, OutputStreamWriter}
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import javax.ws.rs.{Produces, WebApplicationException}
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.{MessageBodyWriter, Provider}

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class ValidationResultJsonWriter extends MessageBodyWriter[ValidationResult] with DefaultJsonProtocol {

  override def isWriteable(`type`: Class[_], genericType: Type, annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[ValidationResult].isAssignableFrom(`type`)

  @throws[IOException]
  @throws[WebApplicationException]
  override def writeTo(validationResult: ValidationResult, `type`: Class[_], genericType: Type,
                       annotations: Array[Annotation], mediaType: MediaType,
                       httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit = {

    val jsObject = JsObject("message" -> JsString(validationResult.message)).toJson.compactPrint

    val writer = new OutputStreamWriter(entityStream)
    writer.write(jsObject)
    writer.flush()
  }

}
