package com.xebialabs.plugin.manager.util

import org.apache.maven.artifact.versioning.ComparableVersion

object VersionComparisonUtil {

  def isLowerVersion(thisVersion: String, thatVersion: String): Boolean = {
    new ComparableVersion(thisVersion).compareTo(new ComparableVersion(thatVersion)) < 0
  }

  def isSameVersion(thisVersion: String, thatVersion: String): Boolean = {
    new ComparableVersion(thisVersion).compareTo(new ComparableVersion(thatVersion)) == 0
  }
}
