package com.xebialabs.plugin.manager.util

import com.xebialabs.plugin.manager.model.FilePlugin
import com.xebialabs.plugin.manager.rest.api.PluginSource
import com.xebialabs.plugin.manager.rest.api.PluginSource.{LOCAL, XLD_OFFICIAL, XLR_OFFICIAL}
import com.xebialabs.xlplatform.sugar.PathSugar.path2File
import grizzled.slf4j.Logging

import java.nio.file.{Files, Path}
import scala.util.{Failure, Success, Using}

object PluginsTraverser extends Logging {

  def traverse(dir: Path, fileExtension: String)(officialCallback: (PluginSource.Value, List[FilePlugin]) => Unit, localCallback: List[FilePlugin] => Unit): Unit = {
    Using(Files.list(dir)) { stream =>
      stream.filter(_.isDirectory)
        .map(dir => PluginSource.withName(dir.getFileName.toString) ->
          dir.listFiles().filter(_.getName.endsWith(fileExtension)).map(filePath => FilePlugin(filePath.toPath)).toList)
        .forEach(fsPluginsBySourceEntry => {
          fsPluginsBySourceEntry._1 match {
            case XLD_OFFICIAL | XLR_OFFICIAL =>
              officialCallback(fsPluginsBySourceEntry._1, fsPluginsBySourceEntry._2)
            case LOCAL =>
              localCallback(fsPluginsBySourceEntry._2)
            case _ => error(s"Could not match plugins directory(source) value ${fsPluginsBySourceEntry._1.toString}, skipping..")
          }
        })
    } match {
      case Success(_) =>
        info(s"Successfully synced plugins")
      case Failure(err) =>
        error(s"Error during plugin sync with message: ${err.getMessage}")
    }
  }
}
