package com.xebialabs.plugin.manager.config

import com.xebialabs.plugin.manager.metadata.XLProduct
import com.xebialabs.plugin.manager.metadata.XLProduct.{XLDeploy, XLRelease}

object ConfigWrapper {
  val EXTENSION_XLDP: String = "xldp"
  val EXTENSION_JAR: String = "jar"
  val GROUP_ID_XLD: String = "com.xebialabs.deployit.plugins"
  val GROUP_ID_XLR: String = "com.xebialabs.xlrelease.plugins"

  var extension: String = _
  var groupId: String = _

  def initWith(product: XLProduct): Unit = {
    product match {
      case XLDeploy =>
        extension = EXTENSION_XLDP
        groupId = GROUP_ID_XLD
      case XLRelease =>
        extension = EXTENSION_JAR
        groupId = GROUP_ID_XLR
      case other => throw new IllegalArgumentException(s"Unknown product name: '$other'")
    }
  }
}