package com.xebialabs.plugin.manager.rest.json

import com.xebialabs.plugin.manager.PluginId
import org.springframework.stereotype.Component
import spray.json._

import java.io.{IOException, OutputStream, OutputStreamWriter}
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.{MessageBodyWriter, Provider}
import javax.ws.rs.{Produces, WebApplicationException}

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class ArtifactJsonWriter extends MessageBodyWriter[PluginId.Artifact] with PluginId.Protocol {

  override def isWriteable(`type`: Class[_], genericType: Type, annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[PluginId.Artifact].isAssignableFrom(`type`)

  override def getSize(viewList: PluginId.Artifact, `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType): Long = -1

  @throws[IOException]
  @throws[WebApplicationException]
  override def writeTo(artifact: PluginId.Artifact, `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = {

    val writer = new OutputStreamWriter(entityStream)
    writer.write(artifact.toJson.compactPrint)
    writer.flush()
  }

}