package com.xebialabs.plugin.manager.metadata

import akka.http.scaladsl.marshallers.sprayjson.SprayJsonSupport
import spray.json._


sealed trait MaturityLevel

object MaturityLevel {
  case object Incubating extends MaturityLevel
  case object Mature extends MaturityLevel
  case object Deprecated extends MaturityLevel

  trait Protocol extends SprayJsonSupport with DefaultJsonProtocol {
    val maturityLevelString: MaturityLevel => String = {
      case Incubating => "Incubating"
      case Mature => "Mature"
      case Deprecated => "Deprecated"
    }
    val maturityLevelWriter: JsonWriter[MaturityLevel] = jsonWriter(m => maturityLevelString(m).toJson)
    val maturityLevelReader: JsonReader[MaturityLevel] = jsonReader[MaturityLevel] {
      case JsString(value) if value.toUpperCase == "INCUBATING" => Incubating
      case JsString(value) if value.toUpperCase == "MATURE" => Mature
      case JsString(value) if value.toUpperCase == "DEPRECATED" => Deprecated
      case unknown =>
        deserializationError(s"Unknown maturity level: '$unknown'")
    }
    implicit val maturityLevelFormat: JsonFormat[MaturityLevel] = jsonFormat(maturityLevelReader, maturityLevelWriter)
  }
}

