package com.xebialabs.plugin.manager.validator

import com.xebialabs.deployit.booter.local.LocalBooter
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.synthetic.TypeSpecification

abstract class SyntheticValidator {
  def validate(types: List[TypeSpecification]): ValidationResult
}

class SyntheticValidatorAtInstallation() extends SyntheticValidator {

  def validate(types: List[TypeSpecification]): ValidationResult = {
    if (LocalBooter.isInitialized) {
      validateInternal(types)
    } else {
      TypeSystemNotInitialized()
    }
  }

  private def validateInternal(types: List[TypeSpecification]): ValidationResult = {
    val conflictingTypes = types.filter(typeSpec => typeSpec.getType.exists()).toSeq

    if (conflictingTypes.nonEmpty) {
      PluginTypesAlreadyExist(toFullyQualifiedNames(conflictingTypes.map(_.getType)))
    } else {
      PluginValid()
    }
  }

  private def toFullyQualifiedNames(types: Seq[Type]): Seq[String] = {
    types.map(t => s"${t.getPrefix}.${t.getName}")
  }

}
