package com.xebialabs.plugin.manager.event

import org.springframework.context.ApplicationEvent

sealed trait PluginManagerEvent {
  def eventSource: AnyRef

  def pluginName: String
}

case class PluginInstalledEvent(eventSource: AnyRef, pluginName: String, requiresRestart: Boolean) extends ApplicationEvent(eventSource) with PluginManagerEvent

case class PluginUpdatedEvent(eventSource: AnyRef, pluginName: String, requiresRestart: Boolean) extends ApplicationEvent(eventSource) with PluginManagerEvent
