/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.service;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.plugin.manager.Plugin;
import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.PluginId$;
import com.xebialabs.plugin.manager.PluginId$PluginIdOps$;
import com.xebialabs.plugin.manager.PluginManager;
import com.xebialabs.plugin.manager.config.PluginManagerProperties;
import com.xebialabs.plugin.manager.event.PluginInstalledEvent;
import com.xebialabs.plugin.manager.event.PluginUpdatedEvent;
import com.xebialabs.plugin.manager.metadata.ArtifactId;
import com.xebialabs.plugin.manager.metadata.ExtendedMetadata;
import com.xebialabs.plugin.manager.metadata.PluginMetadata;
import com.xebialabs.plugin.manager.model.DbPlugin;
import com.xebialabs.plugin.manager.repository.PluginsRepository;
import com.xebialabs.plugin.manager.repository.nexus.NexusPluginRepository;
import com.xebialabs.plugin.manager.repository.nexus.NexusRepositoryConfig;
import com.xebialabs.plugin.manager.repository.nexus.NexusServerConfig;
import com.xebialabs.plugin.manager.rest.api.PluginStatus$;
import com.xebialabs.plugin.manager.rest.dto.PluginDto;
import com.xebialabs.plugin.manager.rest.dto.PluginDto$;
import com.xebialabs.plugin.manager.service.DifferentVersionInstalledAlready;
import com.xebialabs.plugin.manager.service.InstallationFailure;
import com.xebialabs.plugin.manager.service.InstallationResult;
import com.xebialabs.plugin.manager.service.InstallationSuccess;
import com.xebialabs.plugin.manager.service.MultipleInstalledPluginsFoundForUpdate;
import com.xebialabs.plugin.manager.service.PluginNotFound;
import com.xebialabs.plugin.manager.service.PluginNotFoundException;
import com.xebialabs.plugin.manager.service.PluginService$;
import com.xebialabs.plugin.manager.service.PluginUninstallException;
import com.xebialabs.plugin.manager.service.ProductConfig;
import com.xebialabs.plugin.manager.service.RepositoryNotFound;
import com.xebialabs.plugin.manager.service.SameVersionInstalledAlready;
import com.xebialabs.plugin.manager.service.UpdateStrategy$;
import com.xebialabs.plugin.manager.service.UpdateSuccess;
import com.xebialabs.plugin.manager.service.ZeroInstalledPluginsFoundForUpdate;
import com.xebialabs.plugin.manager.startup.PluginReloader;
import com.xebialabs.plugin.manager.validator.PluginValidator;
import com.xebialabs.plugin.manager.validator.TypeSystemValidationResults;
import com.xebialabs.plugin.manager.validator.TypeSystemValidator;
import com.xebialabs.plugin.manager.validator.ValidationResult;
import grizzled.slf4j.Logging;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r\rbaB\u0015+!\u0003\r\t!\u000e\u0005\u0006\t\u0002!\t!\u0012\u0005\u0006\u0013\u00021\tA\u0013\u0005\u0006#\u00021\tA\u0015\u0005\u0006/\u00021\t\u0001\u0017\u0005\u0006?\u00021\t\u0001\u0019\u0005\tW\u0002A)\u0019!C\u0002Y\")1\u000f\u0001D\u0001i\"9\u0011Q\u0004\u0001\u0007\u0002\u0005}\u0001bBA\u0015\u0001\u0019\u0005\u00111\u0006\u0005\u0007\u0003c\u0001A\u0011A#\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA\u001a\u0001\u0011\u0005\u0011q\f\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\t9\u0007\u0001C\u0001\u0003SBq!a!\u0001\t\u0003\t)\tC\u0004\u0002\u0010\u0002!\t!!%\t\u000f\u0005=\u0006\u0001\"\u0003\u00022\"9\u0011\u0011\u0007\u0001\u0005\u0002\u0005\r\u0007bBAo\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0003o\u0004A\u0011BA}\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005\u000fAqAa\u0003\u0001\t\u0003\u0011i\u0001C\u0004\u0003\u0012\u0001!\tAa\u0005\t\u000f\te\u0001\u0001\"\u0001\u0003\u001c!9!q\u0004\u0001\u0005\u0002\t\u0005\u0002b\u0002B'\u0001\u0011\u0005!q\n\u0005\b\u0005S\u0002A\u0011\u0001B6\u0011\u001d\u0011Y\b\u0001C\u0001\u0005{BqA!\"\u0001\t\u0003\u00119\t\u0003\u0004\u0003\u0010\u0002!\t!\u0012\u0005\b\u0005G\u0003A\u0011\u0002BS\u000f\u001d\u0011YK\u000bE\u0001\u0005[3a!\u000b\u0016\t\u0002\t=\u0006b\u0002BYE\u0011\u0005!1\u0017\u0005\n\u0005k\u0013#\u0019!C\u0001\u0005oC\u0001B!2#A\u0003%!\u0011\u0018\u0005\b\u0005\u000f\u0014C\u0011\u0001Be\u0011\u001d\u0011YO\tC\u0001\u0005[Dqaa\u0003#\t\u0003\u0019iAA\u0007QYV<\u0017N\\*feZL7-\u001a\u0006\u0003W1\nqa]3sm&\u001cWM\u0003\u0002.]\u00059Q.\u00198bO\u0016\u0014(BA\u00181\u0003\u0019\u0001H.^4j]*\u0011\u0011GM\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aM\u0001\u0004G>l7\u0001A\n\u0004\u0001Yb\u0004CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$AB!osJ+g\r\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006)1\u000f\u001c45U*\t\u0011)\u0001\u0005he&T(\u0010\\3e\u0013\t\u0019eHA\u0004M_\u001e<\u0017N\\4\u0002\r\u0011Jg.\u001b;%)\u00051\u0005CA\u001cH\u0013\tA\u0005H\u0001\u0003V]&$\u0018a\u0005;za\u0016\u001c\u0016p\u001d;f[Z\u000bG.\u001b3bi>\u0014X#A&\u0011\u00051{U\"A'\u000b\u00059c\u0013!\u0003<bY&$\u0017\r^8s\u0013\t\u0001VJA\nUsB,7+_:uK64\u0016\r\\5eCR|'/A\u0007qYV<\u0017N\\'b]\u0006<WM]\u000b\u0002'B\u0011A+V\u0007\u0002Y%\u0011a\u000b\f\u0002\u000e!2,x-\u001b8NC:\fw-\u001a:\u0002\u001dAdWoZ5o%\u0016dw.\u00193feV\t\u0011\f\u0005\u0002[;6\t1L\u0003\u0002]Y\u000591\u000f^1siV\u0004\u0018B\u00010\\\u00059\u0001F.^4j]J+Gn\\1eKJ\fa\"\u001a<f]R\u0004VO\u00197jg\",'/F\u0001b!\t\u0011\u0017.D\u0001d\u0015\t!W-A\u0004d_:$X\r\u001f;\u000b\u0005\u0019<\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003!\f1a\u001c:h\u0013\tQ7MA\rBaBd\u0017nY1uS>tWI^3oiB+(\r\\5tQ\u0016\u0014\u0018AA3d+\u0005i\u0007C\u00018r\u001b\u0005y'B\u000199\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003e>\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0019I,\u0007o\\:ji>\u0014\u0018.Z:\u0016\u0003U\u0004RA^>~\u0003#i\u0011a\u001e\u0006\u0003qf\fq!\\;uC\ndWM\u0003\u0002{q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005q<(aA'baB\u0019a0a\u0003\u000f\u0007}\f9\u0001E\u0002\u0002\u0002aj!!a\u0001\u000b\u0007\u0005\u0015A'\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0013A\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0005=!AB*ue&twMC\u0002\u0002\na\u0002B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/a\u0013A\u0003:fa>\u001c\u0018\u000e^8ss&!\u00111DA\u000b\u0005E\u0001F.^4j]N\u0014V\r]8tSR|'/_\u0001\u000eC\u0012$'+\u001a9pg&$xN]=\u0015\t\u0005\u0005\u0012q\u0005\t\u0004o\u0005\r\u0012bAA\u0013q\t9!i\\8mK\u0006t\u0007bBA\f\u0011\u0001\u0007\u0011\u0011C\u0001\u0011I\u0016dW\r^3SKB|7/\u001b;pef$B!!\t\u0002.!1\u0011qF\u0005A\u0002u\fAA\\1nK\u00061Q\u000f\u001d3bi\u0016\faa]3be\u000eDG\u0003BA\u001c\u0003'\u0002rA`A\u001d\u0003w\t9%C\u0002}\u0003\u001f\u0001B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003b\u0013\u0001C7fi\u0006$\u0017\r^1\n\t\u0005\u0015\u0013q\b\u0002\u000b\u0003J$\u0018NZ1di&#\u0007#B\u001c\u0002J\u00055\u0013bAA&q\t1q\n\u001d;j_:\u0004B!!\u0010\u0002P%!\u0011\u0011KA \u00059\u0001F.^4j]6+G/\u00193bi\u0006Dq!!\u0016\f\u0001\u0004\t9&A\u0003rk\u0016\u0014\u0018\u0010\u0005\u00038\u0003\u0013j\u0018AD:fCJ\u001c\u0007n\u00144gS\u000eL\u0017\r\u001c\u000b\u0005\u0003o\ti\u0006\u0003\u0004\u0002V1\u0001\r! \u000b\u0005\u0003o\t\t\u0007\u0003\u0004\u0002V5\u0001\r!`\u0001\u0005Y&\u001cH\u000f\u0006\u0002\u00028\u0005iA.[:u\u0013:\u001cH/\u00197mK\u0012$\"!a\u001b\u0011\r\u00055\u0014qOA?\u001d\u0011\ty'a\u001d\u000f\t\u0005\u0005\u0011\u0011O\u0005\u0002s%\u0019\u0011Q\u000f\u001d\u0002\u000fA\f7m[1hK&!\u0011\u0011PA>\u0005\r\u0019V-\u001d\u0006\u0004\u0003kB\u0004c\u0001+\u0002\u0000%\u0019\u0011\u0011\u0011\u0017\u0003\u0011AcWoZ5o\u0013\u0012\fq\"\u001b8ti\u0006dGn\u0014:Va\u0012\fG/\u001a\u000b\u0004\r\u0006\u001d\u0005BB\u0018\u0011\u0001\u0004\tI\tE\u0002U\u0003\u0017K1!!$-\u0005\u0019\u0001F.^4j]\u00069\u0011N\\:uC2dGCBAJ\u00037\u000by\n\u0005\u0003\u0002\u0016\u0006]U\"\u0001\u0016\n\u0007\u0005e%F\u0001\nJ]N$\u0018\r\u001c7bi&|gNU3tk2$\bbBAO#\u0001\u0007\u0011QP\u0001\ta2,x-\u001b8JI\"9\u0011\u0011U\tA\u0002\u0005\r\u0016!\u00022zi\u0016\u001c\b#B\u001c\u0002&\u0006%\u0016bAATq\t)\u0011I\u001d:bsB\u0019q'a+\n\u0007\u00055\u0006H\u0001\u0003CsR,\u0017a\u0004<bY&$\u0017\r^3J]N$\u0018\r\u001c7\u0015\r\u0005M\u0016qXAa)\u0011\t\u0019*!.\t\u0011\u0005]&\u0003\"a\u0001\u0003s\u000bqb];dG\u0016\u001c8oQ1mY\n\f7m\u001b\t\u0006o\u0005m\u00161S\u0005\u0004\u0003{C$\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\u0005u%\u00031\u0001\u0002~!9\u0011\u0011\u0015\nA\u0002\u0005\rF\u0003CAJ\u0003\u000b\fI-a7\t\r\u0005\u001d7\u00031\u0001~\u0003I)\u00070[:uS:<\u0007\u000b\\;hS:t\u0015-\\3\t\u000f\u0005-7\u00031\u0001\u0002N\u0006Qa.Z<WKJ\u001c\u0018n\u001c8\u0011\t\u0005=\u0017Q\u001b\b\u0004)\u0006E\u0017bAAjY\u0005A\u0001\u000b\\;hS:LE-\u0003\u0003\u0002X\u0006e'!\u0003'pG\u0006dg)\u001b7f\u0015\r\t\u0019\u000e\f\u0005\b\u0003C\u001b\u0002\u0019AAR\u0003uIgn\u001d;bY2|%/\u00169eCR,gI]8n%\u0016\u0004xn]5u_JLH\u0003BAq\u0003[\u0004R!a9\u0002j\u001ak!!!:\u000b\u0007\u0005\u001d\b(\u0001\u0003vi&d\u0017\u0002BAv\u0003K\u00141\u0001\u0016:z\u0011\u001d\ty\u000f\u0006a\u0001\u0003c\f!!\u001b3\u0011\t\u0005=\u00171_\u0005\u0005\u0003k\fIN\u0001\u0005BeRLg-Y2u\u0003i!wnV5uQRK\b/Z*zgR,WNV1mS\u0012\fG/[8o)\u0011\tYPa\u0001\u0015\t\u0005M\u0015Q \u0005\t\u0003\u007f,B\u00111\u0001\u0003\u0002\u0005y\u0001\u000f\\;hS:|\u0005/\u001a:bi&|g\u000e\u0005\u00038\u0003w3\u0005BB\u0018\u0016\u0001\u0004\tI)A\u000bj]N$\u0018\r\u001c7Ge>l'+\u001a9pg&$xN]=\u0015\t\u0005M%\u0011\u0002\u0005\b\u0003_4\u0002\u0019AAy\u0003Q)\b\u000fZ1uK\u001a\u0013x.\u001c*fa>\u001c\u0018\u000e^8ssR!\u00111\u0013B\b\u0011\u001d\tyo\u0006a\u0001\u0003c\f!cZ3u!2,x-\u001b8t)>,\u0006\u000fZ1uKR!\u00111\u000eB\u000b\u0011\u0019\u00119\u0002\u0007a\u0001{\u0006Q\u0001\u000f\\;hS:t\u0015-\\3\u00021\u001d,G/\u00169eCR,W*\u0019;dQ&tw\r\u00157vO&t7\u000f\u0006\u0003\u00028\tu\u0001bBAx3\u0001\u0007\u0011\u0011_\u0001\nk:Lgn\u001d;bY2$\"\"!9\u0003$\t\u0005#Q\tB%\u0011\u001d\u0011)C\u0007a\u0001\u0005O\tAB]3q_NLGo\u001c:z\u0013\u0012\u0004BA!\u000b\u0003:9!!1\u0006B\u001b\u001b\t\u0011iC\u0003\u0003\u00030\tE\u0012aA1qS*\u0019!1\u0007\u0017\u0002\tI,7\u000f^\u0005\u0005\u0005o\u0011i#\u0001\u0007QYV<\u0017N\\*pkJ\u001cW-\u0003\u0003\u0003<\tu\"!\u0002,bYV,\u0017b\u0001B q\tYQI\\;nKJ\fG/[8o\u0011\u0019\u0011\u0019E\u0007a\u0001{\u00069qM]8va&#\u0007B\u0002B$5\u0001\u0007Q0\u0001\u0006beRLg-Y2u\u0013\u0012DqAa\u0013\u001b\u0001\u0004\t9&A\u0004wKJ\u001c\u0018n\u001c8\u0002\u000f\u001d,G\u000fT8h_RA!\u0011\u000bB2\u0005K\u00129\u0007E\u00038\u0003\u0013\u0012\u0019\u0006\u0005\u0003\u0003V\t}SB\u0001B,\u0015\u0011\u0011IFa\u0017\u0002\u0005%|'B\u0001B/\u0003\u0011Q\u0017M^1\n\t\t\u0005$q\u000b\u0002\u0005\r&dW\r\u0003\u0004\u0003&m\u0001\r! \u0005\u0007\u0005\u0007Z\u0002\u0019A?\t\r\t\u001d3\u00041\u0001~\u00039\tG\u000f^1dQ6+G/\u00193bi\u0006$BA!\u001c\u0003zA!!q\u000eB;\u001b\t\u0011\tH\u0003\u0003\u0003t\tE\u0012a\u00013u_&!!q\u000fB9\u0005%\u0001F.^4j]\u0012#x\u000eC\u0004\u0002\u001er\u0001\r!! \u0002\u0019\u0005$H/Y2i'R\fG/^:\u0016\u0005\t}\u0004cB\u001c\u0003\u0002\n5$QN\u0005\u0004\u0005\u0007C$!\u0003$v]\u000e$\u0018n\u001c82\u0003\u0019)\u0007\u0010^3oIR!!\u0011\u0012BF!\u0019\ti'a\u001e\u0003n!9!Q\u0012\u0010A\u0002\u0005-\u0014\u0001\u00023bi\u0006\f\u0001b\u001d5vi\u0012|wO\u001c\u0015\u0004?\tM\u0005\u0003\u0002BK\u0005?k!Aa&\u000b\t\te%1T\u0001\u000bC:tw\u000e^1uS>t'B\u0001BO\u0003\u001dQ\u0017m[1si\u0006LAA!)\u0003\u0018\nQ\u0001K]3EKN$(o\\=\u00023A,(\r\\5tQBcWoZ5o\u001b\u0006t\u0017mZ3s\u000bZ,g\u000e\u001e\u000b\u0004\r\n\u001d\u0006b\u0002BUA\u0001\u0007\u00111S\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0002\u001bAcWoZ5o'\u0016\u0014h/[2f!\r\t)JI\n\u0003EY\na\u0001P5oSRtDC\u0001BW\u00039!WMZ1vYR$\u0016.\\3pkR,\"A!/\u0011\t\tm&\u0011Y\u0007\u0003\u0005{S1Aa0p\u0003!!WO]1uS>t\u0017\u0002\u0002Bb\u0005{\u0013\u0001\u0002R;sCRLwN\\\u0001\u0010I\u00164\u0017-\u001e7u)&lWm\\;uA\u0005\t2/\u001a:wKJ\u001chI]8n\u0007>tg-[4\u0015\t\t-'1\u001c\t\u0007}\u0006eRP!4\u0011\r\u0005\r\u0018\u0011\u001eBh!\u0011\u0011\tNa6\u000e\u0005\tM'\u0002\u0002Bk\u0003+\tQA\\3ykNLAA!7\u0003T\n\tb*\u001a=vgN+'O^3s\u0007>tg-[4\t\u000f\tug\u00051\u0001\u0003`\u0006i\u0001\u000f\\;hS:\u001c8i\u001c8gS\u001e\u0004BA!9\u0003h6\u0011!1\u001d\u0006\u0004\u0005Kd\u0013AB2p]\u001aLw-\u0003\u0003\u0003j\n\r(a\u0006)mk\u001eLg.T1oC\u001e,'\u000f\u0015:pa\u0016\u0014H/[3t\u0003Y\u0011X\r]8tSR|'/[3t\rJ|WnQ8oM&<GC\u0002Bx\u0007\u000b\u00199\u0001\u0006\u0003\u0003r\nm\bC\u0002@\u0002:u\u0014\u0019\u0010\u0005\u0004\u0002d\u0006%(Q\u001f\t\u0005\u0005#\u001490\u0003\u0003\u0003z\nM'!\u0006(fqV\u001c(+\u001a9pg&$xN]=D_:4\u0017n\u001a\u0005\b\u0005{<\u00039\u0001B\u0000\u00035\u0001(o\u001c3vGR\u001cuN\u001c4jOB!\u0011QSB\u0001\u0013\r\u0019\u0019A\u000b\u0002\u000e!J|G-^2u\u0007>tg-[4\t\u000f\tuw\u00051\u0001\u0003`\"91\u0011B\u0014A\u0002\t-\u0017aB:feZ,'o]\u0001\u0017G>tg-[4ve\u0016$'+\u001a9pg&$xN]5fgR!1qBB\u0011)\u0011\u0019\tba\b\u0011\r\u0005541CB\f\u0013\u0011\u0019)\"a\u001f\u0003\t1K7\u000f\u001e\t\u0007\u0003G\fIo!\u0007\u0011\t\tE71D\u0005\u0005\u0007;\u0011\u0019NA\u000bOKb,8\u000f\u00157vO&t'+\u001a9pg&$xN]=\t\u000f\tu\b\u0006q\u0001\u0003\u0000\"9!Q\u001c\u0015A\u0002\t}\u0007")
public interface PluginService
extends Logging {
    public static List<Try<NexusPluginRepository>> configuredRepositories(PluginManagerProperties pluginsConfig, ProductConfig productConfig) {
        return PluginService$.MODULE$.configuredRepositories(pluginsConfig, productConfig);
    }

    public static scala.collection.immutable.Map<String, Try<NexusRepositoryConfig>> repositoriesFromConfig(PluginManagerProperties pluginsConfig, scala.collection.immutable.Map<String, Try<NexusServerConfig>> servers, ProductConfig productConfig) {
        return PluginService$.MODULE$.repositoriesFromConfig(pluginsConfig, servers, productConfig);
    }

    public static scala.collection.immutable.Map<String, Try<NexusServerConfig>> serversFromConfig(PluginManagerProperties pluginsConfig) {
        return PluginService$.MODULE$.serversFromConfig(pluginsConfig);
    }

    public static Duration defaultTimeout() {
        return PluginService$.MODULE$.defaultTimeout();
    }

    public TypeSystemValidator typeSystemValidator();

    public PluginManager pluginManager();

    public PluginReloader pluginReloader();

    public ApplicationEventPublisher eventPublisher();

    public static /* synthetic */ ExecutionContext ec$(PluginService $this) {
        return $this.ec();
    }

    default public ExecutionContext ec() {
        return this.pluginManager().ec();
    }

    public Map<String, PluginsRepository> repositories();

    public boolean addRepository(PluginsRepository var1);

    public boolean deleteRepository(String var1);

    public static /* synthetic */ void update$(PluginService $this) {
        $this.update();
    }

    default public void update() {
        if (this.repositories().nonEmpty()) {
            Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((IterableOnce)this.repositories().values().map((Function1 & Serializable)x$1 -> x$1.update()), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec()), PluginService$.MODULE$.defaultTimeout());
            return;
        }
    }

    public static /* synthetic */ scala.collection.immutable.Map search$(PluginService $this, Option query) {
        return $this.search((Option<String>)query);
    }

    default public scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> search(Option<String> query) {
        this.logger().debug((Function0 & Serializable)() -> "search(" + query + ")");
        return (scala.collection.immutable.Map)Await$.MODULE$.result((Awaitable)this.pluginManager().search(query).flatMap((Function1 & Serializable)installed -> Future$.MODULE$.sequence((IterableOnce)this.repositories().values().map((Function1 & Serializable)x$2 -> x$2.search(query)), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec()).map((Function1 & Serializable)x$3 -> (Iterable)x$3.flatten(Predef$.MODULE$.$conforms()), this.ec()).map((Function1 & Serializable)available -> (scala.collection.immutable.Map)available.foldLeft((Object)((IterableOnceOps)installed.map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)Option$.MODULE$.empty()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                scala.collection.immutable.Map acc = (scala.collection.immutable.Map)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    ArtifactId id = (ArtifactId)tuple22._1();
                    Option pm1 = (Option)tuple22._2();
                    Option option = acc.get((Object)id);
                    if (None$.MODULE$.equals(option)) {
                        return (scala.collection.immutable.Map)acc.updated((Object)id, (Object)pm1);
                    }
                    if (option instanceof Some) {
                        return (scala.collection.immutable.Map)pm1.map((Function1 & Serializable)pm -> (scala.collection.immutable.Map)acc.updated((Object)id, (Object)new Some(pm))).getOrElse((Function0 & Serializable)() -> acc);
                    }
                    throw new MatchError((Object)option);
                }
            }
            throw new MatchError((Object)tuple2);
        }), this.ec()), this.ec()), PluginService$.MODULE$.defaultTimeout());
    }

    public static /* synthetic */ scala.collection.immutable.Map searchOfficial$(PluginService $this, String query) {
        return $this.searchOfficial(query);
    }

    default public scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> searchOfficial(String query) {
        return (scala.collection.immutable.Map)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((IterableOnce)this.repositories().values().map((Function1 & Serializable)x$5 -> x$5.search((Option<String>)new Some((Object)query))), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec()).map((Function1 & Serializable)x$6 -> (Iterable)x$6.flatten(Predef$.MODULE$.$conforms()), this.ec()).map((Function1 & Serializable)available -> available.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.ec()), PluginService$.MODULE$.defaultTimeout());
    }

    public static /* synthetic */ scala.collection.immutable.Map search$(PluginService $this, String query) {
        return $this.search(query);
    }

    default public scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> search(String query) {
        return this.search((Option<String>)Option$.MODULE$.apply((Object)query).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7)))));
    }

    public static /* synthetic */ scala.collection.immutable.Map list$(PluginService $this) {
        return $this.list();
    }

    default public scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> list() {
        return this.search((Option<String>)None$.MODULE$);
    }

    public static /* synthetic */ Seq listInstalled$(PluginService $this) {
        return $this.listInstalled();
    }

    default public Seq<PluginId> listInstalled() {
        return this.pluginManager().listInstalled();
    }

    public static /* synthetic */ void installOrUpdate$(PluginService $this, Plugin plugin) {
        $this.installOrUpdate(plugin);
    }

    default public void installOrUpdate(Plugin plugin) {
        this.logger().info((Function0 & Serializable)() -> "Installing plugin " + plugin.id().id() + "...");
        this.pluginManager().installOrUpdate(plugin);
        this.logger().info((Function0 & Serializable)() -> "Installation of plugin " + plugin.id().id() + " to the database is complete. System restart required for the plugin to be ready for usage.");
    }

    public static /* synthetic */ InstallationResult install$(PluginService $this, PluginId pluginId, byte[] bytes) {
        return $this.install(pluginId, bytes);
    }

    default public InstallationResult install(PluginId pluginId, byte[] bytes) {
        this.logger().info((Function0 & Serializable)() -> "Installing plugin " + pluginId + "...");
        return this.validateInstall(pluginId, bytes, (Function0<InstallationResult>)(Function0 & Serializable)() -> {
            Plugin plugin = new Plugin(pluginId, (Option<ExtendedMetadata>)None$.MODULE$, bytes);
            InstallationResult result = this.doWithTypeSystemValidation(plugin, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.pluginManager().install(plugin));
            this.publishPluginManagerEvent(result);
            return result;
        });
    }

    private InstallationResult validateInstall(PluginId pluginId, byte[] bytes, Function0<InstallationResult> successCallback) {
        Seq<PluginId> installedPlugins = this.listInstalled();
        boolean sameVersionAlreadyInstalled = installedPlugins.exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.equals(pluginId)));
        String pluginName = pluginId.name();
        boolean differentVersionAlreadyInstalled = installedPlugins.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)PluginService.$anonfun$validateInstall$2(pluginName, x$9)));
        if (sameVersionAlreadyInstalled) {
            SameVersionInstalledAlready result = new SameVersionInstalledAlready(pluginName);
            this.logger().info((Function0 & Serializable)() -> result.message());
            return result;
        }
        if (differentVersionAlreadyInstalled) {
            DifferentVersionInstalledAlready result = new DifferentVersionInstalledAlready(pluginName);
            this.logger().info((Function0 & Serializable)() -> result.message());
            return result;
        }
        ValidationResult valid = new PluginValidator().validate(bytes, pluginId);
        if (valid.success()) {
            return (InstallationResult)successCallback.apply();
        }
        return valid;
    }

    public static /* synthetic */ InstallationResult update$(PluginService $this, String existingPluginName, PluginId.LocalFile newVersion, byte[] bytes) {
        return $this.update(existingPluginName, newVersion, bytes);
    }

    default public InstallationResult update(String existingPluginName, PluginId.LocalFile newVersion, byte[] bytes) {
        this.logger().info((Function0 & Serializable)() -> "Updating plugin " + existingPluginName + " to version " + newVersion + "...");
        Seq matchingPlugins = (Seq)this.listInstalled().filter((Function1 & Serializable)plugin -> BoxesRunTime.boxToBoolean((boolean)PluginService.$anonfun$update$3(existingPluginName, plugin)));
        if (matchingPlugins.size() > 1) {
            MultipleInstalledPluginsFoundForUpdate result = new MultipleInstalledPluginsFoundForUpdate(existingPluginName);
            this.logger().info((Function0 & Serializable)() -> result.message());
            return result;
        }
        if (matchingPlugins.isEmpty()) {
            ZeroInstalledPluginsFoundForUpdate result = new ZeroInstalledPluginsFoundForUpdate(existingPluginName);
            this.logger().info((Function0 & Serializable)() -> result.message());
            return result;
        }
        PluginId.LocalFile alreadyInstalled = (PluginId.LocalFile)matchingPlugins.head();
        Plugin newPlugin = new Plugin(newVersion, (Option<ExtendedMetadata>)None$.MODULE$, bytes);
        InstallationResult result = this.doWithTypeSystemValidation(newPlugin, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.pluginManager().update(alreadyInstalled, newPlugin));
        this.publishPluginManagerEvent(result);
        return result;
    }

    public static /* synthetic */ Try installOrUpdateFromRepository$(PluginService $this, PluginId.Artifact id) {
        return $this.installOrUpdateFromRepository(id);
    }

    default public Try<BoxedUnit> installOrUpdateFromRepository(PluginId.Artifact id) {
        return (Try)this.repositories().get((Object)id.repository()).map((Function1 & Serializable)repo -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Plugin plugin = (Plugin)Await$.MODULE$.result(repo.get(id), PluginService$.MODULE$.defaultTimeout());
            InstallationResult installationResult = this.doWithTypeSystemValidation(plugin, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.pluginManager().install(plugin));
            this.publishPluginManagerEvent(installationResult);
            if (!installationResult.success()) {
                throw new IllegalStateException(installationResult.message());
            }
        }).recoverWith((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ PluginService $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().warn((Function0 & Serializable)() -> A1.getMessage());
                return (B1)new Failure(A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.Throwable )}, serializedLambda);
            }
        })).getOrElse((Function0 & Serializable)() -> new Failure((Throwable)new NotFoundException("Unknown plugin repository '" + id.repository(), new Object[0])));
    }

    private InstallationResult doWithTypeSystemValidation(Plugin plugin, Function0<BoxedUnit> pluginOperation) {
        InstallationResult installationResult;
        TypeSystemValidationResults validations = this.typeSystemValidator().validate(plugin);
        validations.messages().foreach((Function1 & Serializable)info -> {
            PluginService.$anonfun$doWithTypeSystemValidation$1(this, info);
            return BoxedUnit.UNIT;
        });
        validations.warnings().foreach((Function1 & Serializable)warning -> {
            PluginService.$anonfun$doWithTypeSystemValidation$3(this, warning);
            return BoxedUnit.UNIT;
        });
        validations.errors().foreach((Function1 & Serializable)error -> {
            PluginService.$anonfun$doWithTypeSystemValidation$5(this, error);
            return BoxedUnit.UNIT;
        });
        if (validations.failed()) {
            return new InstallationFailure(plugin.id().name(), validations.messages().mkString("\n"), validations.warnings(), validations.errors());
        }
        Try try_ = Try$.MODULE$.apply(pluginOperation);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Unable install/update " + plugin.id().name(), (Function0 & Serializable)() -> exception);
            installationResult = new InstallationFailure(plugin.id().name(), exception.getMessage(), validations.warnings(), validations.errors());
        } else if (try_ instanceof Success) {
            installationResult = new InstallationSuccess(plugin.id().name(), true, validations.warnings());
        } else {
            throw new MatchError((Object)try_);
        }
        InstallationResult result = installationResult;
        if (validations.restartRequired()) {
            return result;
        }
        this.pluginReloader().reloadPlugin(plugin);
        return new InstallationSuccess(plugin.id().name(), false, validations.warnings());
    }

    public static /* synthetic */ InstallationResult installFromRepository$(PluginService $this, PluginId.Artifact id) {
        return $this.installFromRepository(id);
    }

    /*
     * WARNING - void declaration
     */
    default public InstallationResult installFromRepository(PluginId.Artifact id) {
        InstallationResult installationResult;
        try {
            installationResult = (InstallationResult)this.repositories().get((Object)id.repository()).map((Function1 & Serializable)repo -> {
                Plugin plugin = (Plugin)Await$.MODULE$.result(repo.get(id), PluginService$.MODULE$.defaultTimeout());
                return this.validateInstall(plugin.id(), plugin.bytes(), (Function0<InstallationResult>)(Function0 & Serializable)() -> {
                    InstallationResult result = this.doWithTypeSystemValidation(plugin, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.pluginManager().install(plugin));
                    this.publishPluginManagerEvent(result);
                    return result;
                });
            }).getOrElse((Function0 & Serializable)() -> {
                RepositoryNotFound result = new RepositoryNotFound(id.repository(), id.name());
                this.logger().info((Function0 & Serializable)() -> result.message());
                return result;
            });
        }
        catch (Exception err) {
            void var3_3;
            this.logger().warn((Function0 & Serializable)() -> err.getMessage());
            PluginNotFound result = new PluginNotFound(id.name());
            this.logger().info((Function0 & Serializable)() -> result.message());
            installationResult = var3_3;
        }
        return installationResult;
    }

    public static /* synthetic */ InstallationResult updateFromRepository$(PluginService $this, PluginId.Artifact id) {
        return $this.updateFromRepository(id);
    }

    default public InstallationResult updateFromRepository(PluginId.Artifact id) {
        return (InstallationResult)this.repositories().get((Object)id.repository()).map((Function1 & Serializable)repo2 -> {
            Seq<PluginId> installedPlugins = this.getPluginsToUpdate(id.name());
            scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> availablePlugins = this.getUpdateMatchingPlugins(id);
            InstallationResult updateResult = UpdateStrategy$.MODULE$.doUpdate((PluginsRepository)repo2, installedPlugins, availablePlugins, id.name(), (Function3<PluginsRepository, PluginId.Artifact, PluginId, InstallationResult>)(Function3 & Serializable)(repo, newVersion, existing) -> this.doUpdate$1((PluginsRepository)repo, (PluginId.Artifact)newVersion, (PluginId)existing));
            this.logger().info((Function0 & Serializable)() -> updateResult.message());
            this.publishPluginManagerEvent(updateResult);
            return updateResult;
        }).getOrElse((Function0 & Serializable)() -> {
            RepositoryNotFound result = new RepositoryNotFound(id.repository(), id.name());
            this.logger().info((Function0 & Serializable)() -> result.message());
            return result;
        });
    }

    public static /* synthetic */ Seq getPluginsToUpdate$(PluginService $this, String pluginName) {
        return $this.getPluginsToUpdate(pluginName);
    }

    default public Seq<PluginId> getPluginsToUpdate(String pluginName) {
        String pluginNameCriteria = pluginName.endsWith("*") ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(pluginName), 1) : pluginName;
        return (Seq)this.listInstalled().filter((Function1 & Serializable)plugin -> BoxesRunTime.boxToBoolean((boolean)PluginService.$anonfun$getPluginsToUpdate$1(pluginNameCriteria, plugin)));
    }

    public static /* synthetic */ scala.collection.immutable.Map getUpdateMatchingPlugins$(PluginService $this, PluginId.Artifact id) {
        return $this.getUpdateMatchingPlugins(id);
    }

    default public scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> getUpdateMatchingPlugins(PluginId.Artifact id) {
        if (id.name().endsWith("*")) {
            return this.searchOfficial(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(id.name()), 1));
        }
        return (scala.collection.immutable.Map)this.searchOfficial(id.name()).filter((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)PluginService.$anonfun$getUpdateMatchingPlugins$1(id, item)));
    }

    public static /* synthetic */ Try uninstall$(PluginService $this, Enumeration.Value repositoryId, String groupId, String artifactId, Option version) {
        return $this.uninstall(repositoryId, groupId, artifactId, (Option<String>)version);
    }

    default public Try<BoxedUnit> uninstall(Enumeration.Value repositoryId, String groupId, String artifactId, Option<String> version) {
        this.logger().info((Function0 & Serializable)() -> "Uninstalling plugin " + repositoryId + ":" + groupId + ":" + artifactId + "-" + version);
        Option<DbPlugin> option = this.pluginManager().getPluginBy(repositoryId, groupId, artifactId, version);
        if (option instanceof Some) {
            Some some = (Some)option;
            DbPlugin plugin = (DbPlugin)some.value();
            if (this.pluginManager().uninstall(plugin)) {
                this.pluginManager().revertPreviousVersionIfNecessary(plugin);
                return new Success((Object)BoxedUnit.UNIT);
            }
            return new Failure((Throwable)((Object)new PluginUninstallException(plugin, "Only plugins in " + PluginStatus$.MODULE$.READY_FOR_INSTALL() + " status can be uninstalled.")));
        }
        if (None$.MODULE$.equals(option)) {
            return new Failure((Throwable)((Object)new PluginNotFoundException("Plugin " + repositoryId + ":" + groupId + ":" + artifactId + "-" + version + " not found in the system.")));
        }
        throw new MatchError(option);
    }

    public static /* synthetic */ Option getLogo$(PluginService $this, String repositoryId, String groupId, String artifactId) {
        return $this.getLogo(repositoryId, groupId, artifactId);
    }

    default public Option<File> getLogo(String repositoryId, String groupId, String artifactId) {
        return this.repositories().get((Object)repositoryId).flatMap((Function1 & Serializable)repo -> repo.getLogo(groupId, artifactId).map((Function1 & Serializable)logo -> logo));
    }

    public static /* synthetic */ PluginDto attachMetadata$(PluginService $this, PluginId pluginId) {
        return $this.attachMetadata(pluginId);
    }

    default public PluginDto attachMetadata(PluginId pluginId) {
        String repoId = pluginId.source().toString();
        Option metadata = this.repositories().get((Object)repoId).flatMap((Function1 & Serializable)repo -> repo.getMetadata(PluginId$PluginIdOps$.MODULE$.toArtifactId$extension(PluginId$.MODULE$.PluginIdOps(pluginId))).map((Function1 & Serializable)pluginsMeta -> pluginsMeta));
        return new PluginDto(pluginId, (Option<PluginMetadata>)metadata, PluginDto$.MODULE$.apply$default$3());
    }

    public static /* synthetic */ Function1 attachStatus$(PluginService $this) {
        return $this.attachStatus();
    }

    default public Function1<PluginDto, PluginDto> attachStatus() {
        scala.collection.immutable.Map<String, Enumeration.Value> statuses = this.pluginManager().fetchPluginStatuses();
        return (Function1 & Serializable)pluginDto -> {
            Option x$1 = statuses.get((Object)pluginDto.plugin().name());
            PluginId x$2 = pluginDto.copy$default$1();
            Option<PluginMetadata> x$3 = pluginDto.copy$default$2();
            return pluginDto.copy(x$2, x$3, (Option<Enumeration.Value>)x$1);
        };
    }

    public static /* synthetic */ Seq extend$(PluginService $this, Seq data) {
        return $this.extend((Seq<PluginId>)data);
    }

    default public Seq<PluginDto> extend(Seq<PluginId> data) {
        return (Seq)((IterableOps)data.map((Function1 & Serializable)pluginId -> this.attachMetadata((PluginId)pluginId))).map(this.attachStatus());
    }

    public static /* synthetic */ void shutdown$(PluginService $this) {
        $this.shutdown();
    }

    @PreDestroy
    default public void shutdown() {
        this.logger().info((Function0 & Serializable)() -> "Shutting down LocalPluginManager...");
        Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((IterableOnce)this.repositories().values().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends PluginsRepository, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof NexusPluginRepository) {
                    NexusPluginRepository nexusPluginRepository = (NexusPluginRepository)A1;
                    return (B1)nexusPluginRepository.shutdown();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(PluginsRepository x1) {
                PluginsRepository pluginsRepository = x1;
                return pluginsRepository instanceof NexusPluginRepository;
            }
        }), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec()), package.IntMult$.MODULE$.$times$extension(package$.MODULE$.IntMult(this.repositories().size()), PluginService$.MODULE$.defaultTimeout()));
    }

    private void publishPluginManagerEvent(InstallationResult result) {
        InstallationResult installationResult = result;
        if (installationResult instanceof InstallationSuccess) {
            InstallationSuccess installationSuccess = (InstallationSuccess)installationResult;
            String pluginName = installationSuccess.pluginName();
            boolean requiresRestart = installationSuccess.requiresRestart();
            this.eventPublisher().publishEvent((ApplicationEvent)new PluginInstalledEvent(this, pluginName, requiresRestart));
            return;
        }
        if (installationResult instanceof UpdateSuccess) {
            UpdateSuccess updateSuccess = (UpdateSuccess)installationResult;
            String pluginName = updateSuccess.pluginName();
            boolean requiresRestart = updateSuccess.requiresRestart();
            this.eventPublisher().publishEvent((ApplicationEvent)new PluginUpdatedEvent(this, pluginName, requiresRestart));
            return;
        }
    }

    public static /* synthetic */ boolean $anonfun$validateInstall$2(String pluginName$1, PluginId x$9) {
        return x$9.name().equals(pluginName$1);
    }

    public static /* synthetic */ boolean $anonfun$update$3(String existingPluginName$1, PluginId plugin) {
        return PluginId$.MODULE$.PluginIdOps(plugin).name().startsWith(existingPluginName$1) && PluginId$.MODULE$.PluginIdOps(plugin) instanceof PluginId.LocalFile;
    }

    public static /* synthetic */ void $anonfun$doWithTypeSystemValidation$1(PluginService $this, String info) {
        $this.logger().info((Function0 & Serializable)() -> info);
    }

    public static /* synthetic */ void $anonfun$doWithTypeSystemValidation$3(PluginService $this, String warning) {
        $this.logger().warn((Function0 & Serializable)() -> warning);
    }

    public static /* synthetic */ void $anonfun$doWithTypeSystemValidation$5(PluginService $this, String error) {
        $this.logger().error((Function0 & Serializable)() -> error);
    }

    private InstallationResult doUpdate$1(PluginsRepository repo, PluginId.Artifact newVersion, PluginId existing) {
        Plugin newPlugin = (Plugin)Await$.MODULE$.result(repo.get(newVersion), PluginService$.MODULE$.defaultTimeout());
        return this.doWithTypeSystemValidation(newPlugin, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.pluginManager().update(existing, newPlugin));
    }

    public static /* synthetic */ boolean $anonfun$getPluginsToUpdate$1(String pluginNameCriteria$1, PluginId plugin) {
        return PluginId$.MODULE$.PluginIdOps(plugin).name().startsWith(pluginNameCriteria$1) && PluginId$.MODULE$.PluginIdOps(plugin) instanceof PluginId.Artifact;
    }

    public static /* synthetic */ boolean $anonfun$getUpdateMatchingPlugins$1(PluginId.Artifact id$5, Tuple2 item) {
        return ((String)((ArtifactId)item._1()).repository().get()).equals(id$5.repository()) && ((ArtifactId)item._1()).groupId().equals(id$5.groupId()) && ((ArtifactId)item._1()).artifactId().equals(id$5.artifactId());
    }

    public static void $init$(PluginService $this) {
    }
}

