package com.xebialabs.plugin.manager.validator

import com.xebialabs.plugin.manager.service.InstallationResult

abstract class ValidationResult(success: Boolean, message: String) extends InstallationResult(success = success, message = message)

case class InvalidArchive(pluginName: String)
  extends ValidationResult(success = false, message = s"$pluginName is not a valid archive file")

case class TypeDefinitionNotValid(pluginName: String)
  extends ValidationResult(success = false, message = s"$pluginName doesn't have a valid type definition")

case class PluginValid() extends ValidationResult(success = true, message = "Plugin is valid")

case class PluginTypesAlreadyExist(types: Seq[String])
  extends ValidationResult(success = false, message = s"Unable to install plugin. Types ${types.mkString(", ")} already exist in the type system")

case class MissingBaseTypes(types: Seq[String])
  extends ValidationResult(success = false, message = s"Unable to install plugin. Base types ${types.mkString(", ")} are missing in the system")

case class TypeSystemNotInitialized()
  extends ValidationResult(success = true, message = s"Type system is not initialized, unable to perform types validation.")
