package com.xebialabs.plugin.manager.compatibility

import scala.util.Try

object Jdk17ReportUtils {

  def displayCompatibilityReport(results: Map[String, Try[Boolean]])(implicit output: StringBuffer): StringBuffer = {
    println("JDK17 compatibility report")
    println("-------------------------------------------------------------------------------------------")
    if (results.isEmpty) {
      println("No plugins found for validation")
    } else {
      val compatiblePlugins = results.filter(e => e._2.isSuccess && e._2.get).keys
      val incompatiblePlugins = results.filter(res => res._2.isSuccess && !res._2.get).keys
      val uncheckedPlugins = results.filter(res => res._2.isFailure).keys

      if (incompatiblePlugins.nonEmpty) {
        println("The following plugins are not compatible with JDK17:")
        incompatiblePlugins.toList.sorted.foreach(plugin => println(plugin))
        println("-------------------------------------------------------------------------------------------")
      }
      if (uncheckedPlugins.nonEmpty) {
        println("The following plugins were not able to be checked. Please manually verify JDK17 compatibility:")
        uncheckedPlugins.toList.sorted.foreach(plugin => println(plugin))
        println("-------------------------------------------------------------------------------------------")
      }
      if (compatiblePlugins.nonEmpty) {
        println("The following plugins are compatible with JDK17:")
        compatiblePlugins.toList.sorted.foreach(plugin => println(plugin))
        println("-------------------------------------------------------------------------------------------")
      }
    }
    output
  }

  private def println(s: String)(implicit output: StringBuffer): StringBuffer = output.append(s).append(System.lineSeparator())
}
